/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.db.file.AbstractFileDatabase;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.io.File;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;

public class FormFileDatabase
extends AbstractFileDatabase<Form>
implements FormDatabase {
    public FormFileDatabase(String directory, ObjectMapper objectMapper) {
        super(Form.class, directory, objectMapper);
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.forAllFiles(file -> {
            Form document = (Form)this.loadFile((File)file);
            if (document != null) {
                consumer.accept((FormDatabase.FormMetadataRow)ImmutableFormMetadataRow.of((String)document.getId(), (Form.Metadata)document.getMetadata()));
            }
        });
    }

    @NonNull
    protected Form updateDocumentId(@NonNull Form form, String id) {
        return ImmutableForm.builder().from(form).id(id).build();
    }

    @NonNull
    protected Form updateDocumentRev(@NonNull Form form, String rev) {
        return ImmutableForm.builder().from(form).rev(rev).build();
    }
}

