/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.dialob.api;

import io.dialob.db.dialob.api.DialobApiDbSettings;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DialobApiTemplate {
    private final RestTemplate restTemplate;
    private final URI uri;
    private final DialobApiDbSettings settings;

    public DialobApiTemplate(RestTemplate restTemplate, DialobApiDbSettings settings) {
        this.restTemplate = restTemplate;
        this.settings = settings;
        this.uri = settings.getUri();
    }

    public <T> T findOne(@NonNull String resource, @NonNull String id, String rev, Class<T> entityType) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.uri).pathSegment(new String[]{resource, id});
        if (StringUtils.isNotBlank((CharSequence)rev)) {
            builder = builder.queryParam("rev", new Object[]{rev});
        }
        URI url = builder.build().toUri();
        return this.doRequest(url, HttpMethod.GET, null, entityType);
    }

    @NonNull
    public <T> T save(@NonNull String resource, String id, @NonNull T document) {
        HttpMethod httpMethod = HttpMethod.POST;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.uri).pathSegment(new String[]{resource});
        if (StringUtils.isNotBlank((CharSequence)id)) {
            builder = builder.pathSegment(new String[]{id});
            httpMethod = HttpMethod.PUT;
        }
        URI url = builder.build().toUri();
        Class<?> entityType = document.getClass();
        return this.doRequest(url, httpMethod, document, entityType);
    }

    protected <E> ResponseEntity<E> handleResponse(ResponseEntity<E> responseEntity) {
        return responseEntity;
    }

    protected <T> T doRequest(URI url, HttpMethod httpMethod, T document, Class<T> responseType) {
        return (T)this.handleResponse(this.restTemplate.exchange(url, httpMethod, this.httpEntity(document), responseType)).getBody();
    }

    protected HttpEntity httpEntity(Object document) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Accept", "application/json");
        DialobApiDbSettings.Authentication authentication = this.settings.getAuthentication();
        if (authentication != null) {
            String apikey = authentication.getApikey();
            httpHeaders.set("Authorization", "ApiKey " + apikey);
        }
        if (document == null) {
            return new HttpEntity(this.decorateHttpHeaders(httpHeaders));
        }
        httpHeaders.set("Content-Type", "application/json");
        return new HttpEntity(document, this.decorateHttpHeaders(httpHeaders));
    }

    protected MultiValueMap<String, String> decorateHttpHeaders(HttpHeaders httpHeaders) {
        return httpHeaders;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

