/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.assets.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dialob.db.assets.repository.AssetRepository;
import io.dialob.db.spi.exceptions.DatabaseException;
import io.dialob.settings.DialobSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class GenericAssetRepository
implements AssetRepository {
    private static final String REV_LATEST = "LATEST";
    private static final String QUERY_TYPE_NAME = "name";
    public static final ParameterizedTypeReference<List<ObjectNode>> PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<List<ObjectNode>>(){};
    private final RestTemplate restTemplate;
    private final DialobSettings.DialobAssetsServiceSettings settings;
    private final ObjectMapper objectMapper;

    public GenericAssetRepository(RestTemplate restTemplate, DialobSettings settings, ObjectMapper objectMapper) {
        this.restTemplate = restTemplate;
        this.settings = settings.getAssets().getService();
        this.objectMapper = objectMapper;
    }

    @Override
    @NonNull
    public AssetRepository.AssetBuilder createBuilder() {
        return new AssetRepository.AssetBuilder(){
            private String document;

            @Override
            @NonNull
            public AssetRepository.AssetBuilder document(@NonNull String document) {
                this.document = document;
                return this;
            }

            @Override
            @NonNull
            public ObjectNode build() {
                Assert.notNull((Object)this.document, (String)"document can't be null!");
                return GenericAssetRepository.this.postExchange(this.document);
            }
        };
    }

    @Override
    @NonNull
    public AssetRepository.AssetQuery createQuery() {
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "DIALOB");
        return new AssetRepository.AssetQuery(){

            @Override
            @NonNull
            public AssetRepository.AssetQuery rev(@NonNull String rev) {
                if (!GenericAssetRepository.REV_LATEST.equalsIgnoreCase(rev)) {
                    params.put("rev", rev);
                }
                return this;
            }

            @Override
            @NonNull
            public AssetRepository.AssetQuery metadata() {
                params.put("criteriaType", "METADATA");
                return this;
            }

            @Override
            @NonNull
            public AssetRepository.AssetQuery id(@NonNull String id) {
                params.put(GenericAssetRepository.QUERY_TYPE_NAME, id);
                return this;
            }

            @Override
            public Optional<ObjectNode> get() {
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)((CharSequence)params.get(GenericAssetRepository.QUERY_TYPE_NAME))) ? 1 : 0) != 0, (String)"id must be defined!");
                List<ObjectNode> result = GenericAssetRepository.this.getExchange(params);
                if (result.isEmpty()) {
                    return Optional.empty();
                }
                if (result.size() > 1) {
                    throw new DatabaseException(String.format("expecting one or zero documents but found: %s for criteria: %s", result.size(), params.toString()));
                }
                return Optional.of(result.get(0));
            }

            @Override
            @NonNull
            public List<ObjectNode> list() {
                return GenericAssetRepository.this.getExchange(params);
            }

            @Override
            public void delete() {
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)((CharSequence)params.get(GenericAssetRepository.QUERY_TYPE_NAME))) ? 1 : 0) != 0, (String)"id must be defined!");
                GenericAssetRepository.this.deletExchange(params);
            }
        };
    }

    protected void deletExchange(Map<String, String> params) {
        try {
            UriComponentsBuilder uri = UriComponentsBuilder.fromUriString((String)this.settings.getUrl());
            params.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> uri.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.createHeaders());
            ResponseEntity response = this.restTemplate.exchange(uri.toUriString(), HttpMethod.DELETE, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ObjectNode>>(){}, new Object[0]);
            Assert.isTrue((boolean)response.getStatusCode().is2xxSuccessful(), (String)("Asset status was: " + response.getStatusCodeValue() + " but expecting 200!"));
        }
        catch (Exception e) {
            throw new DatabaseException(String.format("failed to get assets: %s! ", e.getMessage()));
        }
    }

    protected List<ObjectNode> getExchange(Map<String, String> params) {
        try {
            UriComponentsBuilder uri = UriComponentsBuilder.fromUriString((String)this.settings.getUrl());
            params.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> uri.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.createHeaders());
            ResponseEntity response = this.restTemplate.exchange(uri.toUriString(), HttpMethod.GET, requestEntity, PARAMETERIZED_TYPE_REFERENCE, new Object[0]);
            Assert.isTrue((boolean)response.getStatusCode().is2xxSuccessful(), (String)("Asset status was: " + response.getStatusCodeValue() + " but expecting 200!"));
            return (List)response.getBody();
        }
        catch (Exception e) {
            throw new DatabaseException(String.format("failed to get assets: %s! ", e.getMessage()), (Throwable)e);
        }
    }

    protected ObjectNode postExchange(String document) {
        try {
            ObjectNode asset = this.objectMapper.createObjectNode();
            asset.put("type", "DIALOB");
            asset.put("content", document);
            HttpEntity requestEntity = new HttpEntity((Object)asset.toString(), (MultiValueMap)this.createHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.settings.getUrl(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ObjectNode>>(){}, new Object[0]);
            Assert.isTrue((boolean)response.getStatusCode().is2xxSuccessful(), (String)("Asset status was: " + response.getStatusCodeValue() + " but expecting 200!"));
            return (ObjectNode)((List)response.getBody()).get(0);
        }
        catch (Exception e) {
            throw new DatabaseException(String.format("failed to handle asset request: %s! ", e.getMessage()));
        }
    }

    protected HttpHeaders createHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (!StringUtils.isEmpty((CharSequence)this.settings.getAuthorization())) {
            headers.set("Authorization", this.settings.getAuthorization());
        }
        return headers;
    }
}

