/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.assets.serialization;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.db.assets.serialization.TemplateDeserializer;
import java.io.IOException;

public class AssetFormDeserializer
extends TemplateDeserializer {
    private final ObjectMapper objectMapper;

    public AssetFormDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Form deserialize(ObjectNode input) {
        try {
            JsonNode node = this.objectMapper.readTree(input.get("content").asText());
            Form form = (Form)this.objectMapper.treeToValue((TreeNode)node, Form.class);
            if (this.isRevision(input)) {
                return ImmutableForm.builder().from(form).rev(this.getRevision(input)).metadata((Form.Metadata)ImmutableFormMetadata.builder().from(form.getMetadata()).putAdditionalProperties(this.getRevisions((JsonNode)input)).putAdditionalProperties(this.getTags((JsonNode)input)).build()).build();
            }
            return form;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

