/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.controllers.util;

import io.dialob.client.spi.support.FileUtils;
import io.dialob.spring.composer.controllers.util.IdeOnClasspath;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ControllerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerUtil.class);
    private static final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public static IdeOnClasspath ideOnClasspath(String configContextPath) {
        String contextPath;
        try {
            contextPath = FileUtils.cleanPath((String)configContextPath).length() <= 1 ? "/" : "/" + FileUtils.cleanPath((String)configContextPath) + "/";
        }
        catch (Exception e) {
            return new IdeOnClasspath();
        }
        try {
            String path = "webjars/dialob-composer-ui/" + ControllerUtil.getVersion() + "/";
            String js = ControllerUtil.chunkJs();
            String hash = js.substring(0, js.length() - 3);
            String manifest = ControllerUtil.resolveRuntimeScript("classpath*:**/dialob-composer-ui/**/manifest.json");
            List<String> css = Arrays.asList(contextPath + path + "static/css/" + ControllerUtil.resolveRuntimeScript("classpath*:**/dialob-composer-ui/**/static/css/main*.css"));
            IdeOnClasspath config = new IdeOnClasspath(hash, css, contextPath + path + manifest, contextPath + path + "static/js/" + js);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Hdes IDE is enabled." + System.lineSeparator() + config);
            }
            return config;
        }
        catch (Exception e) {
            LOGGER.debug("Hdes IDE is disabled.");
            return new IdeOnClasspath();
        }
    }

    private static String getVersion() throws IOException {
        Resource[] resources = resolver.getResources("classpath*:**/dialob-composer-ui/**/index.html");
        if (resources.length > 0) {
            String uri = resources[0].getURL().toString();
            String[] paths = uri.split("\\/");
            return paths[paths.length - 2];
        }
        return null;
    }

    private static String resolveRuntimeScript(String ideManifestJsPattern) throws IOException {
        Resource[] resources = resolver.getResources(ideManifestJsPattern);
        if (resources.length > 0) {
            return resources[0].getFilename();
        }
        return null;
    }

    private static String chunkJs() throws IOException {
        int n = 0;
        Resource[] resources = resolver.getResources("classpath*:**/dialob-composer-ui/**/main*.js");
        Resource[] resourceArray = resources;
        int n2 = resourceArray.length;
        if (n < n2) {
            Resource resource = resourceArray[n];
            return resource.getFilename();
        }
        return null;
    }

    private static String getContextPath(String serverContextPath) {
        Object cp = "";
        if (StringUtils.isNotBlank((CharSequence)serverContextPath)) {
            if (!serverContextPath.startsWith("/")) {
                cp = "/";
            }
            if (((String)(cp = (String)cp + serverContextPath)).endsWith("/")) {
                cp = ((String)cp).substring(0, ((String)cp).length() - 1);
            }
        }
        return cp;
    }

    private static String getUrl(String proto, String host, String serverContextPath) {
        String contextPath = ControllerUtil.getContextPath(serverContextPath);
        if (StringUtils.isBlank((CharSequence)proto)) {
            proto = "http";
        }
        if (!((String)proto).endsWith(":")) {
            proto = (String)proto + ":";
        }
        String baseUrl = (String)proto + "//" + host + contextPath;
        return baseUrl;
    }

    public static String getRestUrl(String proto, String host, String apiContextPath, String serverContextPath) {
        return FileUtils.cleanPath((String)ControllerUtil.getUrl(proto, host, serverContextPath)) + "/" + FileUtils.cleanPath((String)apiContextPath) + "/";
    }
}

