/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.controllers.exception;

import java.io.Serializable;
import java.text.MessageFormat;

public class Message
implements Serializable {
    private static final long serialVersionUID = -1526741610475665283L;
    private String code;
    private String logCode;
    private String value;
    private String context;
    private Object[] args;

    public Message() {
    }

    public Message(String code, String value, Object[] args) {
        this.code = code;
        this.value = value;
        this.context = null;
        this.args = args;
    }

    public Message(String code, String value) {
        this.code = code;
        this.value = value;
        this.context = null;
    }

    public Message(String code, String value, String context) {
        this.code = code;
        this.value = value;
        this.context = context;
    }

    public Message(String code, String value, String context, Object[] args) {
        this.code = code;
        this.value = value;
        this.context = context;
        this.args = args;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public String getContext() {
        return this.context;
    }

    public Message setCode(String id) {
        this.code = id;
        return this;
    }

    public Message setValue(String value) {
        this.value = value;
        return this;
    }

    public Message setContext(String context) {
        this.context = context;
        return this;
    }

    public String toString() {
        String msg = this.args == null ? (this.value == null ? "" : this.value.toString()) : MessageFormat.format(this.value, this.args);
        return "code: " + this.code + ", " + msg;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Message setArgs(Object[] args) {
        this.args = args;
        return this;
    }

    public String getLogCode() {
        return this.logCode;
    }

    public Message setLogCode(String logCode) {
        this.logCode = logCode;
        return this;
    }
}

