/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.controllers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.spring.composer.controllers.DialobComposerServiceController;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposerServiceController.InitSession", generator="Immutables")
@Immutable
public final class ImmutableInitSession
implements DialobComposerServiceController.InitSession {
    private final String formId;
    private final String language;
    private final ImmutableMap<String, Object> contextValues;

    private ImmutableInitSession(String formId, String language, ImmutableMap<String, Object> contextValues) {
        this.formId = formId;
        this.language = language;
        this.contextValues = contextValues;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="contextValues")
    public ImmutableMap<String, Object> getContextValues() {
        return this.contextValues;
    }

    public final ImmutableInitSession withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableInitSession(newValue, this.language, this.contextValues);
    }

    public final ImmutableInitSession withLanguage(String value) {
        String newValue = Objects.requireNonNull(value, "language");
        if (this.language.equals(newValue)) {
            return this;
        }
        return new ImmutableInitSession(this.formId, newValue, this.contextValues);
    }

    public final ImmutableInitSession withContextValues(Map<String, ? extends Object> entries) {
        if (this.contextValues == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableInitSession(this.formId, this.language, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitSession && this.equalTo((ImmutableInitSession)another);
    }

    private boolean equalTo(ImmutableInitSession another) {
        return this.formId.equals(another.formId) && this.language.equals(another.language) && this.contextValues.equals(another.contextValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.language.hashCode();
        h += (h << 5) + this.contextValues.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InitSession").omitNullValues().add("formId", (Object)this.formId).add("language", (Object)this.language).add("contextValues", this.contextValues).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInitSession fromJson(Json json) {
        Builder builder = ImmutableInitSession.builder();
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.language != null) {
            builder.language(json.language);
        }
        if (json.contextValues != null) {
            builder.putAllContextValues(json.contextValues);
        }
        return builder.build();
    }

    public static ImmutableInitSession copyOf(DialobComposerServiceController.InitSession instance) {
        if (instance instanceof ImmutableInitSession) {
            return (ImmutableInitSession)instance;
        }
        return ImmutableInitSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposerServiceController.InitSession", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FORM_ID = 1L;
        private static final long INIT_BIT_LANGUAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String formId;
        @Nullable
        private String language;
        private ImmutableMap.Builder<String, Object> contextValues = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposerServiceController.InitSession instance) {
            Objects.requireNonNull(instance, "instance");
            this.formId(instance.getFormId());
            this.language(instance.getLanguage());
            this.putAllContextValues(instance.getContextValues());
            return this;
        }

        @JsonProperty(value="formId")
        @CanIgnoreReturnValue
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="language")
        @CanIgnoreReturnValue
        public final Builder language(String language) {
            this.language = Objects.requireNonNull(language, "language");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putContextValues(String key, Object value) {
            this.contextValues.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putContextValues(Map.Entry<String, ? extends Object> entry) {
            this.contextValues.put(entry);
            return this;
        }

        @JsonProperty(value="contextValues")
        @CanIgnoreReturnValue
        public final Builder contextValues(Map<String, ? extends Object> entries) {
            this.contextValues = ImmutableMap.builder();
            return this.putAllContextValues(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllContextValues(Map<String, ? extends Object> entries) {
            this.contextValues.putAll(entries);
            return this;
        }

        public ImmutableInitSession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInitSession(this.formId, this.language, (ImmutableMap<String, Object>)this.contextValues.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("language");
            }
            return "Cannot build InitSession, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposerServiceController.InitSession", generator="Immutables")
    static final class Json
    implements DialobComposerServiceController.InitSession {
        @Nullable
        String formId;
        @Nullable
        String language;
        @Nullable
        Map<String, Object> contextValues = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="language")
        public void setLanguage(String language) {
            this.language = language;
        }

        @JsonProperty(value="contextValues")
        public void setContextValues(Map<String, Object> contextValues) {
            this.contextValues = contextValues;
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLanguage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getContextValues() {
            throw new UnsupportedOperationException();
        }
    }
}

