/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.controllers;

import io.dialob.client.spi.support.FileUtils;
import io.dialob.spring.composer.ComposerAutoConfiguration;
import io.dialob.spring.composer.config.UiConfigBean;
import io.dialob.spring.composer.controllers.util.ControllerUtil;
import io.dialob.spring.composer.controllers.util.IdeOnClasspath;
import io.dialob.spring.composer.controllers.util.ThymeleafConfig;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DialobComposerUiController {
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${dialob.composer.service.service-path:/assets}")
    private String servicePath;
    private final UiConfigBean config;
    private final IdeOnClasspath ideOnClasspath;
    private final Optional<ComposerAutoConfiguration.SpringIdeTokenSupplier> token;

    @RequestMapping(value={"${dialob.composer.ui.service-path:/ide}"}, produces={"text/html"})
    public String ui(HttpServletRequest request, Model model, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Forwarded-Proto", required=false, defaultValue="") String proto) {
        Optional<Object> token = this.token.map(t -> t.get(request)).orElse(Optional.empty());
        String restUrl = ControllerUtil.getRestUrl(proto, host, this.servicePath, this.contextPath);
        if (this.config.isHttps() && !restUrl.startsWith("https")) {
            restUrl = restUrl.replaceFirst("http", "https");
        }
        ThymeleafConfig thymeleaf = new ThymeleafConfig().setContextPath("/" + FileUtils.cleanPath((String)this.config.getServicePath())).setUrl(restUrl).setManifest(this.ideOnClasspath.getManifest()).setCss(this.ideOnClasspath.getCss()).setMainJs(this.ideOnClasspath.getMainJs()).setHash(this.ideOnClasspath.getHash()).setStatus(this.config.getStatus()).setOidc(this.config.getOidc()).setCsrf(token.orElse(null));
        model.addAttribute("config", (Object)thymeleaf);
        return "dialob-ui";
    }

    public DialobComposerUiController(UiConfigBean config, IdeOnClasspath ideOnClasspath, Optional<ComposerAutoConfiguration.SpringIdeTokenSupplier> token) {
        this.config = config;
        this.ideOnClasspath = ideOnClasspath;
        this.token = token;
    }
}

