/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.form.Form;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobFill;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.client.spi.DialobComposerImpl;
import io.dialob.client.spi.DialobInMemoryFill;
import io.dialob.client.spi.form.FormActions;
import io.dialob.client.spi.form.FormActionsUpdatesCallback;
import io.dialob.spring.composer.controllers.ImmutableInitSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${dialob.composer.service.service-path:/assets}"})
public class DialobComposerServiceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobComposerServiceController.class);
    private final DialobClient client;
    private final DialobComposer composer;
    private final DialobFill fill;
    private final ObjectMapper objectMapper;
    private static final Duration timeout = Duration.ofMillis(10000L);
    private long warningThreshold = 2000000000L;
    private boolean returnStackTrace = true;

    public DialobComposerServiceController(DialobClient client, ObjectMapper objectMapper, ApplicationContext ctx) {
        this.client = client;
        this.composer = new DialobComposerImpl(client);
        this.fill = DialobInMemoryFill.builder().build("DialobComposerServiceController", client);
        this.objectMapper = objectMapper;
        String servicePath = ctx.getEnvironment().getProperty("dialob.composer.service.service-path");
        String uiPath = ctx.getEnvironment().getProperty("dialob.composer.ui.service-path");
        String uiEnabled = ctx.getEnvironment().getProperty("dialob.composer.ui.enabled");
        StringBuilder log = new StringBuilder().append("Dialob, Composer Service: UP").append(System.lineSeparator()).append("service paths:").append(System.lineSeparator()).append("  - GET, html").append(uiPath).append(": ").append("dialob composer user interface, enabled: ").append(uiEnabled).append(System.lineSeparator()).append("  - GET, json").append(servicePath).append(": ").append("/models").append(": ").append("returns all form revisions").append(System.lineSeparator()).append("  - GET, json").append(servicePath).append(": ").append("/forms/{id}").append(": ").append("returns form body based on id").append(System.lineSeparator()).append("  - GET, json").append(servicePath).append(": ").append("/sessions/{sessionId}").append(": ").append("returns fill session based on id").append(System.lineSeparator()).append("  - POST Actions, json").append(servicePath).append(": ").append("/sessions/{sessionId}").append(": ").append("returns actions for given session id evals").append(System.lineSeparator());
        LOGGER.info(log.toString());
    }

    @GetMapping(path={"/models"}, produces={"application/json"})
    public DialobComposer.ComposerState models() {
        DialobComposer.ComposerState state = (DialobComposer.ComposerState)this.composer.get().await().atMost(timeout);
        return state;
    }

    @GetMapping(path={"/forms/{id}"}, produces={"application/json"})
    public Form forms(@PathVariable String id) {
        Optional form = (Optional)this.composer.get().onItem().transform(e -> e.getForms().values().stream().filter(a -> a.getId().equals(id)).findFirst()).await().atMost(timeout);
        if (form.isEmpty()) {
            // empty if block
        }
        return ((DialobDocument.FormDocument)form.get()).getData();
    }

    @GetMapping(value={"/sessions/{sessionId}"})
    public ResponseEntity<Actions> sessionState(@PathVariable(value="sessionId") String sessionId) {
        long start = System.nanoTime();
        LOGGER.debug("Received 'GET /{}' request", (Object)sessionId);
        ImmutableActions.Builder actions = ImmutableActions.builder();
        try {
            Questionnaire session = (Questionnaire)this.fill.query().get(sessionId).await().atMost(timeout);
            DialobStore.StoreState state = (DialobStore.StoreState)this.client.store().query().get().await().atMost(timeout);
            DialobClient.ProgramEnvir envir = this.client.envir().from(state).build();
            QuestionnaireSession questionnaireSession = this.client.executor(envir).restore(session).toSession();
            FormActions formActions = new FormActions();
            questionnaireSession.buildFullForm((QuestionnaireSession.UpdatesCallback)new FormActionsUpdatesCallback(formActions));
            actions.actions((Iterable)formActions.getActions());
            actions.rev(questionnaireSession.getRevision());
        }
        catch (DialobErrorHandler.DocumentNotFoundException e) {
            return this.createQuestionnaireNotFoundResponse(sessionId, e);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Dialog fetch failed: %s", e.getMessage()), (Throwable)e);
            return this.createServiceErrorResponse(e);
        }
        long time = System.nanoTime() - start;
        if (time > this.warningThreshold) {
            LOGGER.warn("Request time {}ns exceeds warning threshold {}.", (Object)time, (Object)this.warningThreshold);
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Request time {}ms", (Object)((double)time / 1000000.0));
        }
        return ResponseEntity.ok((Object)actions.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/sessions"})
    public ResponseEntity<DialobFill.FillEntry> createSession(@RequestBody InitSession init) {
        long start = System.nanoTime();
        try {
            DialobFill.FillEntry session = (DialobFill.FillEntry)this.fill.create().formId(init.getFormId()).language(init.getLanguage()).contextValues(init.getContextValues()).build().await().atMost(timeout);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)session);
            return responseEntity;
        }
        finally {
            long time = System.nanoTime() - start;
            if (time > this.warningThreshold) {
                LOGGER.warn("Request time {}ns exceeds warning threshold {}.", (Object)time, (Object)this.warningThreshold);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Request time {}ms", (Object)((double)time / 1000000.0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/sessions/{sessionId}"})
    public ResponseEntity<Actions> answers(@PathVariable(value="sessionId") String sessionId, @RequestBody Actions actions) {
        long start = System.nanoTime();
        try {
            Questionnaire session = (Questionnaire)this.fill.query().get(sessionId).await().atMost(timeout);
            DialobStore.StoreState state = (DialobStore.StoreState)this.client.store().query().get().await().atMost(timeout);
            DialobClient.ProgramEnvir envir = this.client.envir().from(state).build();
            DialobClient.ExecutorBody result = this.client.executor(envir).restore(session).actions(actions).executeAndGetBody();
            this.fill.save(result.getQuestionnaire()).await().atMost(timeout);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)result.getActions());
            return responseEntity;
        }
        catch (DialobErrorHandler.DocumentNotFoundException e) {
            ResponseEntity<Actions> responseEntity = this.createQuestionnaireNotFoundResponse(sessionId, e);
            return responseEntity;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Dialog update failed: %s", e.getMessage()), (Throwable)e);
            ResponseEntity<Actions> responseEntity = this.createServiceErrorResponse(e);
            return responseEntity;
        }
        finally {
            long time = System.nanoTime() - start;
            if (time > this.warningThreshold) {
                LOGGER.warn("Request time {}ns exceeds warning threshold {}.", (Object)time, (Object)this.warningThreshold);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Request time {}ms", (Object)((double)time / 1000000.0));
            }
        }
    }

    private ResponseEntity<Actions> createServiceErrorResponse(Exception e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ImmutableActions.builder().addActions(this.createNotifyServerErrorAction(e)).build());
    }

    private Action createNotifyServerErrorAction(Exception e) {
        ImmutableAction.Builder action = ImmutableAction.builder();
        action.type(Action.Type.SERVER_ERROR);
        action.serverEvent(Boolean.valueOf(true));
        if (this.returnStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            action.message(e.getMessage());
            action.trace(sw.toString());
        }
        return action.build();
    }

    private ResponseEntity<Actions> createQuestionnaireNotFoundResponse(String sessionId, DialobErrorHandler.DocumentNotFoundException e) {
        LOGGER.debug("Action QUESTIONNAIRE_NOT_FOUND: backend response '{}'", (Object)(e != null ? e.getMessage() : "Security block"));
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)ImmutableActions.builder().addActions((Action)ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true)).message("not found").id(sessionId).build()).build());
    }

    @JsonSerialize(as=ImmutableInitSession.class)
    @JsonDeserialize(as=ImmutableInitSession.class)
    @Value.Immutable
    public static interface InitSession {
        public String getFormId();

        public String getLanguage();

        public Map<String, Object> getContextValues();
    }
}

