/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.config;

import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="dialob.composer.ui")
@Component
public class UiConfigBean {
    public static final String REST_SPRING_CTX_PATH = "dialob.composer.service.service-path";
    public static final String REST_SPRING_CTX_PATH_EXP = "${dialob.composer.service.service-path:/assets}";
    public static final String UI_SPRING_CTX_PATH = "dialob.composer.ui.service-path";
    public static final String UI_SPRING_CTX_PATH_EXP = "${dialob.composer.ui.service-path:/ide}";
    public static final String UI_ENABLED = "dialob.composer.ui.enabled";
    @Value(value="${enabled:true}")
    private boolean enabled;
    @Value(value="${redirect:true}")
    private String redirect;
    @Value(value="${service-path:/ide}")
    private String servicePath;
    @Value(value="${https:false}")
    private boolean https;
    @Nullable
    @Value(value="${oidc-path:}")
    private String oidc;
    @Nullable
    @Value(value="${status-path:}")
    private String status;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public boolean isHttps() {
        return this.https;
    }

    @Nullable
    public String getOidc() {
        return this.oidc;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public void setOidc(@Nullable String oidc) {
        this.oidc = oidc;
    }

    public void setStatus(@Nullable String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiConfigBean)) {
            return false;
        }
        UiConfigBean other = (UiConfigBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isHttps() != other.isHttps()) {
            return false;
        }
        String this$redirect = this.getRedirect();
        String other$redirect = other.getRedirect();
        if (this$redirect == null ? other$redirect != null : !this$redirect.equals(other$redirect)) {
            return false;
        }
        String this$servicePath = this.getServicePath();
        String other$servicePath = other.getServicePath();
        if (this$servicePath == null ? other$servicePath != null : !this$servicePath.equals(other$servicePath)) {
            return false;
        }
        String this$oidc = this.getOidc();
        String other$oidc = other.getOidc();
        if (this$oidc == null ? other$oidc != null : !this$oidc.equals(other$oidc)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiConfigBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isHttps() ? 79 : 97);
        String $redirect = this.getRedirect();
        result = result * 59 + ($redirect == null ? 43 : $redirect.hashCode());
        String $servicePath = this.getServicePath();
        result = result * 59 + ($servicePath == null ? 43 : $servicePath.hashCode());
        String $oidc = this.getOidc();
        result = result * 59 + ($oidc == null ? 43 : $oidc.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "UiConfigBean(enabled=" + this.isEnabled() + ", redirect=" + this.getRedirect() + ", servicePath=" + this.getServicePath() + ", https=" + this.isHttps() + ", oidc=" + this.getOidc() + ", status=" + this.getStatus() + ")";
    }
}

