/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableDialobCreds;
import io.dialob.client.pgsql.PgSqlDialobStore;
import io.dialob.spring.composer.config.PgConfigBean;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"dialob.formdb.pg.enabled"}, havingValue="true")
public class PgConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgConfig.class);

    @Bean
    public DialobStore hdesStore(Optional<DialobStore.DialobCredsSupplier> authorProvider, PgConfigBean config, ObjectMapper objectMapper) {
        DialobStore.DialobCredsSupplier creds = authorProvider.isEmpty() ? () -> ImmutableDialobCreds.builder().user("assetManager").email("assetManager@resys.io").build() : authorProvider.get();
        return PgSqlDialobStore.builder().pgHost(config.getPgHost()).pgPort(config.getPgPort()).pgDb(config.getPgDb()).pgPoolSize(config.getPgPoolSize()).pgUser(config.getPgUser()).pgPass(config.getPgPass()).objectMapper(objectMapper).repoName(config.getRepositoryName()).headName(config.getBranchSpecifier()).authorProvider(() -> ((DialobStore.DialobCreds)creds.get()).getUser()).objectMapper(objectMapper).build();
    }

    @ConditionalOnProperty(name={"dialob.formdb.pg.autoCreate"}, havingValue="true")
    @Bean
    public Loader autoCreate(DialobStore store) {
        return new Loader(store);
    }

    public static class Loader {
        private final DialobStore store;

        public Loader(DialobStore store) {
            this.store = store;
        }

        @PostConstruct
        public void doLoad() {
            Boolean autCreated = (Boolean)this.store.repo().createIfNot().await().atMost(Duration.ofMillis(1000L));
            LOGGER.debug("REPO auto created: " + autCreated);
        }
    }
}

