/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableDialobCreds;
import io.dialob.client.spi.DialobStoreFileImpl;
import io.dialob.spring.composer.config.FileConfigBean;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"dialob.formdb.file.enabled"}, havingValue="true")
public class FileConfig {
    @Bean
    public DialobStore dialobStore(Optional<DialobStore.DialobCredsSupplier> authorProvider, FileConfigBean gitConfigBean, ObjectMapper objectMapper) {
        DialobStore.DialobCredsSupplier creds = authorProvider.isEmpty() ? (gitConfigBean.getEmail() != null && gitConfigBean.getEmail().contains("@") ? () -> ImmutableDialobCreds.builder().user(gitConfigBean.getEmail().split("@")[0]).email(gitConfigBean.getEmail()).build() : () -> ImmutableDialobCreds.builder().user("assetManager").email("assetManager@resys.io").build()) : authorProvider.get();
        return DialobStoreFileImpl.builder().pgDb(gitConfigBean.getPath()).objectMapper(objectMapper).authorProvider(() -> ((DialobStore.DialobCreds)creds.get()).getUser()).build();
    }
}

