/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.spring.composer.ComposerAutoConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ComposerAutoConfiguration.IdeToken", generator="Immutables")
@Immutable
public final class ImmutableIdeToken
implements ComposerAutoConfiguration.IdeToken {
    private final String key;
    private final String value;

    private ImmutableIdeToken(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public final ImmutableIdeToken withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableIdeToken(newValue, this.value);
    }

    public final ImmutableIdeToken withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableIdeToken(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdeToken && this.equalTo((ImmutableIdeToken)another);
    }

    private boolean equalTo(ImmutableIdeToken another) {
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IdeToken").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public static ImmutableIdeToken copyOf(ComposerAutoConfiguration.IdeToken instance) {
        if (instance instanceof ImmutableIdeToken) {
            return (ImmutableIdeToken)instance;
        }
        return ImmutableIdeToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ComposerAutoConfiguration.IdeToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ComposerAutoConfiguration.IdeToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableIdeToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIdeToken(this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build IdeToken, some of required attributes are not set " + attributes;
        }
    }
}

