/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.composer;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobStore;
import io.dialob.client.spi.DialobClientImpl;
import io.dialob.client.spi.DialobMemoryStore;
import io.dialob.client.spi.event.EventPublisher;
import io.dialob.client.spi.event.QuestionnaireEventPublisher;
import io.dialob.client.spi.function.AsyncFunctionInvoker;
import io.dialob.client.spi.function.FunctionRegistryImpl;
import io.dialob.rule.parser.function.DefaultFunctions;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.spring.composer.config.FileConfig;
import io.dialob.spring.composer.config.FileConfigBean;
import io.dialob.spring.composer.config.PgConfig;
import io.dialob.spring.composer.config.PgConfigBean;
import io.dialob.spring.composer.config.UiConfigBean;
import io.dialob.spring.composer.controllers.DialobComposerServiceController;
import io.dialob.spring.composer.controllers.DialobComposerUiController;
import io.dialob.spring.composer.controllers.DialobComposerUiRedirectController;
import io.dialob.spring.composer.controllers.util.ControllerUtil;
import io.dialob.spring.composer.controllers.util.IdeOnClasspath;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

@Configuration
@ConditionalOnProperty(name={"dialob.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={FileConfigBean.class, PgConfigBean.class, UiConfigBean.class})
@Import(value={FileConfig.class, PgConfig.class})
public class ComposerAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerAutoConfiguration.class);
    @Value(value="${dialob.formdb.inmemory.path:classpath*:assets/}")
    private String inmemoryPath;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    @Bean
    @ConditionalOnProperty(name={"dialob.formdb.inmemory.enabled"}, havingValue="true")
    public DialobStore dialobStore(ObjectMapper objectMapper) {
        return DialobMemoryStore.builder().objectMapper(objectMapper).path(this.inmemoryPath).build();
    }

    @ConditionalOnProperty(name={"dialob.composer.ui.enabled"}, havingValue="true")
    @Bean
    public DialobComposerUiController dialobComposerUiController(UiConfigBean composerConfig, Optional<SpringIdeTokenSupplier> token) {
        IdeOnClasspath config = ControllerUtil.ideOnClasspath(this.contextPath);
        LOGGER.info("Dialob, UI Controller: " + config.getMainJs());
        return new DialobComposerUiController(composerConfig, config, token);
    }

    @ConditionalOnProperty(name={"dialob.composer.ui.enabled", "dialob.composer.ui.redirect"}, havingValue="true")
    @Bean
    public DialobComposerUiRedirectController dialobUIRedirectController(UiConfigBean composerConfig) {
        LOGGER.info("Dialob, UI Redirect: UP");
        return new DialobComposerUiRedirectController(composerConfig);
    }

    @ConditionalOnProperty(name={"dialob.composer.service.enabled"}, havingValue="true")
    @Bean
    public DialobComposerServiceController dialobComposerServiceController(DialobClient client, ObjectMapper objectMapper, ApplicationContext ctx) {
        return new DialobComposerServiceController(client, objectMapper, ctx);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        LOGGER.info("Dialob, Composer Jackson Modules: UP");
        return builder -> builder.modules(new Module[]{new GuavaModule(), new JavaTimeModule(), new Jdk8Module()});
    }

    @Bean
    public DialobClient dialobClient(ApplicationEventPublisher springAppEventPublisher, TaskExecutor springTaskExecutor, ObjectMapper objectMapper, Optional<DialobStore> store) {
        FunctionRegistryImpl functionRegistry = new FunctionRegistryImpl();
        DefaultFunctions defaultFunctions = new DefaultFunctions((FunctionRegistry)functionRegistry);
        QuestionnaireSessionEventPublisher appEventPublisher = new QuestionnaireSessionEventPublisher(springTaskExecutor, springAppEventPublisher);
        QuestionnaireEventPublisher eventPublisher = new QuestionnaireEventPublisher((EventPublisher)appEventPublisher);
        AsyncFunctionInvoker asyncFunctionInvoker = new AsyncFunctionInvoker((FunctionRegistry)functionRegistry);
        if (store.isEmpty()) {
            store = Optional.of(DialobMemoryStore.builder().objectMapper(objectMapper).path(this.inmemoryPath).build());
        }
        return DialobClientImpl.builder().store(store.get()).objectMapper(objectMapper).eventPublisher(eventPublisher).asyncFunctionInvoker(asyncFunctionInvoker).functionRegistry((FunctionRegistry)functionRegistry).build();
    }

    public String getInmemoryPath() {
        return this.inmemoryPath;
    }

    public void setInmemoryPath(String inmemoryPath) {
        this.inmemoryPath = inmemoryPath;
    }

    @Value.Immutable
    public static interface IdeToken {
        public String getKey();

        public String getValue();
    }

    @FunctionalInterface
    public static interface SpringIdeTokenSupplier {
        public Optional<IdeToken> get(HttpServletRequest var1);
    }

    public static class QuestionnaireSessionEventPublisher
    implements EventPublisher {
        private final TaskExecutor taskExecutor;
        private final ApplicationEventPublisher delegate;

        public void publish(@Nonnull EventPublisher.Event event) {
            this.taskExecutor.execute(() -> this.delegate.publishEvent((Object)event));
        }

        public QuestionnaireSessionEventPublisher(TaskExecutor taskExecutor, ApplicationEventPublisher delegate) {
            this.taskExecutor = taskExecutor;
            this.delegate = delegate;
        }
    }
}

