package io.dialob.spring.composer.controllers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposerServiceController.InitSession}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInitSession.builder()}.
 */
@Generated(from = "DialobComposerServiceController.InitSession", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInitSession
    implements DialobComposerServiceController.InitSession {
  private final String formId;
  private final String language;
  private final ImmutableMap<String, Object> contextValues;

  private ImmutableInitSession(
      String formId,
      String language,
      ImmutableMap<String, Object> contextValues) {
    this.formId = formId;
    this.language = language;
    this.contextValues = contextValues;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @JsonProperty("language")
  @Override
  public String getLanguage() {
    return language;
  }

  /**
   * @return The value of the {@code contextValues} attribute
   */
  @JsonProperty("contextValues")
  @Override
  public ImmutableMap<String, Object> getContextValues() {
    return contextValues;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposerServiceController.InitSession#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInitSession withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableInitSession(newValue, this.language, this.contextValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposerServiceController.InitSession#getLanguage() language} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for language
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInitSession withLanguage(String value) {
    String newValue = Objects.requireNonNull(value, "language");
    if (this.language.equals(newValue)) return this;
    return new ImmutableInitSession(this.formId, newValue, this.contextValues);
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the contextValues map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInitSession withContextValues(Map<String, ? extends Object> entries) {
    if (this.contextValues == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableInitSession(this.formId, this.language, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInitSession} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInitSession
        && equalTo((ImmutableInitSession) another);
  }

  private boolean equalTo(ImmutableInitSession another) {
    return formId.equals(another.formId)
        && language.equals(another.language)
        && contextValues.equals(another.contextValues);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code language}, {@code contextValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + language.hashCode();
    h += (h << 5) + contextValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InitSession} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InitSession")
        .omitNullValues()
        .add("formId", formId)
        .add("language", language)
        .add("contextValues", contextValues)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposerServiceController.InitSession", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements DialobComposerServiceController.InitSession {
    @Nullable String formId;
    @Nullable String language;
    @Nullable Map<String, Object> contextValues = ImmutableMap.of();
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("language")
    public void setLanguage(String language) {
      this.language = language;
    }
    @JsonProperty("contextValues")
    public void setContextValues(Map<String, Object> contextValues) {
      this.contextValues = contextValues;
    }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLanguage() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getContextValues() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableInitSession fromJson(Json json) {
    ImmutableInitSession.Builder builder = ImmutableInitSession.builder();
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.language != null) {
      builder.language(json.language);
    }
    if (json.contextValues != null) {
      builder.putAllContextValues(json.contextValues);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposerServiceController.InitSession} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InitSession instance
   */
  public static ImmutableInitSession copyOf(DialobComposerServiceController.InitSession instance) {
    if (instance instanceof ImmutableInitSession) {
      return (ImmutableInitSession) instance;
    }
    return ImmutableInitSession.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInitSession ImmutableInitSession}.
   * <pre>
   * ImmutableInitSession.builder()
   *    .formId(String) // required {@link DialobComposerServiceController.InitSession#getFormId() formId}
   *    .language(String) // required {@link DialobComposerServiceController.InitSession#getLanguage() language}
   *    .putContextValues|putAllContextValues(String =&gt; Object) // {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableInitSession builder
   */
  public static ImmutableInitSession.Builder builder() {
    return new ImmutableInitSession.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInitSession ImmutableInitSession}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposerServiceController.InitSession", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM_ID = 0x1L;
    private static final long INIT_BIT_LANGUAGE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String formId;
    private @Nullable String language;
    private ImmutableMap.Builder<String, Object> contextValues = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InitSession} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposerServiceController.InitSession instance) {
      Objects.requireNonNull(instance, "instance");
      formId(instance.getFormId());
      language(instance.getLanguage());
      putAllContextValues(instance.getContextValues());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposerServiceController.InitSession#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposerServiceController.InitSession#getLanguage() language} attribute.
     * @param language The value for language 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("language")
    public final Builder language(String language) {
      this.language = Objects.requireNonNull(language, "language");
      initBits &= ~INIT_BIT_LANGUAGE;
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} map.
     * @param key The key in the contextValues map
     * @param value The associated value in the contextValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putContextValues(String key, Object value) {
      this.contextValues.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putContextValues(Map.Entry<String, ? extends Object> entry) {
      this.contextValues.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} map. Nulls are not permitted
     * @param entries The entries that will be added to the contextValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contextValues")
    public final Builder contextValues(Map<String, ? extends Object> entries) {
      this.contextValues = ImmutableMap.builder();
      return putAllContextValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposerServiceController.InitSession#getContextValues() contextValues} map. Nulls are not permitted
     * @param entries The entries that will be added to the contextValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllContextValues(Map<String, ? extends Object> entries) {
      this.contextValues.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableInitSession ImmutableInitSession}.
     * @return An immutable instance of InitSession
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInitSession build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInitSession(formId, language, contextValues.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_LANGUAGE) != 0) attributes.add("language");
      return "Cannot build InitSession, some of required attributes are not set " + attributes;
    }
  }
}
