package io.dialob.spring.composer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ComposerAutoConfiguration.IdeToken}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIdeToken.builder()}.
 */
@Generated(from = "ComposerAutoConfiguration.IdeToken", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIdeToken implements ComposerAutoConfiguration.IdeToken {
  private final String key;
  private final String value;

  private ImmutableIdeToken(String key, String value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposerAutoConfiguration.IdeToken#getKey() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIdeToken withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableIdeToken(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposerAutoConfiguration.IdeToken#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIdeToken withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableIdeToken(this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIdeToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIdeToken
        && equalTo((ImmutableIdeToken) another);
  }

  private boolean equalTo(ImmutableIdeToken another) {
    return key.equals(another.key)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IdeToken} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IdeToken")
        .omitNullValues()
        .add("key", key)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ComposerAutoConfiguration.IdeToken} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IdeToken instance
   */
  public static ImmutableIdeToken copyOf(ComposerAutoConfiguration.IdeToken instance) {
    if (instance instanceof ImmutableIdeToken) {
      return (ImmutableIdeToken) instance;
    }
    return ImmutableIdeToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIdeToken ImmutableIdeToken}.
   * <pre>
   * ImmutableIdeToken.builder()
   *    .key(String) // required {@link ComposerAutoConfiguration.IdeToken#getKey() key}
   *    .value(String) // required {@link ComposerAutoConfiguration.IdeToken#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableIdeToken builder
   */
  public static ImmutableIdeToken.Builder builder() {
    return new ImmutableIdeToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIdeToken ImmutableIdeToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ComposerAutoConfiguration.IdeToken", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String key;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IdeToken} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ComposerAutoConfiguration.IdeToken instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link ComposerAutoConfiguration.IdeToken#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link ComposerAutoConfiguration.IdeToken#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIdeToken ImmutableIdeToken}.
     * @return An immutable instance of IdeToken
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIdeToken build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIdeToken(key, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build IdeToken, some of required attributes are not set " + attributes;
    }
  }
}
