/*
 * Copyright © 2015 - 2021 ReSys (info@dialob.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.dialob.cloud.gcp;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent;

@Slf4j
public class DialobQuestionnaireEventsToPubSubBridge {
  private final DialobQuestionnaireEventsMessagingGateway messagingGateway;

  public DialobQuestionnaireEventsToPubSubBridge(DialobQuestionnaireEventsMessagingGateway messagingGateway) {
    this.messagingGateway = messagingGateway;
  }

  @EventListener
  public void onQuestionnaireCompletedEvent(QuestionnaireCompletedEvent event) {
    messagingGateway.onQuestionnaireCompletedEvent(event);
  }
}
