/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.gcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherOperations;
import com.google.cloud.spring.pubsub.integration.outbound.PubSubMessageHandler;
import com.google.cloud.spring.pubsub.support.converter.JacksonPubSubMessageConverter;
import io.dialob.cloud.gcp.DialobFormEventMessagingGateway;
import io.dialob.cloud.gcp.DialobFormEventsToPubSubBridge;
import io.dialob.cloud.gcp.DialobQuestionnaireEventsMessagingGateway;
import io.dialob.cloud.gcp.DialobQuestionnaireEventsToPubSubBridge;
import io.dialob.settings.DialobSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.cloud.gcp.pubsub", name={"enabled"}, havingValue="true")
@IntegrationComponentScan(basePackages={"io.dialob.cloud.gcp"})
public class DialobCloudGcpAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobCloudGcpAutoConfiguration.class);

    @Bean
    public JacksonPubSubMessageConverter jacksonPubSubMessageConverter(ObjectMapper objectMapper) {
        return new JacksonPubSubMessageConverter(objectMapper);
    }

    @Bean
    @ServiceActivator(inputChannel="dialobQuestionnairePubSubOutputChannel")
    @ConditionalOnProperty(prefix="dialob.gcp.pubsub", name={"questionnaireEventsTopic"})
    public MessageHandler questionnaireMessageHandler(PubSubTemplate pubSubTemplate, DialobSettings settings) {
        return new PubSubMessageHandler((PubSubPublisherOperations)pubSubTemplate, settings.getGcp().getPubsub().getQuestionnaireEventsTopic());
    }

    @Bean
    @ServiceActivator(inputChannel="dialobFormPubSubOutputChannel")
    @ConditionalOnProperty(prefix="dialob.gcp.pubsub", name={"formEventsTopic"})
    public MessageHandler formMessageHandler(PubSubTemplate pubSubTemplate, DialobSettings settings) {
        return new PubSubMessageHandler((PubSubPublisherOperations)pubSubTemplate, settings.getGcp().getPubsub().getFormEventsTopic());
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.gcp.pubsub", name={"questionnaireEventsTopic"})
    public DialobQuestionnaireEventsToPubSubBridge dialobQuestionnaireEventsToPubSubBridge(DialobQuestionnaireEventsMessagingGateway messagingGateway) {
        return new DialobQuestionnaireEventsToPubSubBridge(messagingGateway);
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.gcp.pubsub", name={"formEventsTopic"})
    public DialobFormEventsToPubSubBridge dialobFormEventsToPubSubBridge(DialobFormEventMessagingGateway messagingGateway) {
        return new DialobFormEventsToPubSubBridge(messagingGateway);
    }
}

