/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.cloud.aws.AbstractEventsToSNSBridge;
import io.dialob.integration.api.event.FormDeletedEvent;
import io.dialob.integration.api.event.FormTaggedEvent;
import io.dialob.integration.api.event.FormUpdatedEvent;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;

public class DialobFormEventsToSNSBridge
extends AbstractEventsToSNSBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobFormEventsToSNSBridge.class);

    public DialobFormEventsToSNSBridge(SnsAsyncClient amazonSNS, ObjectMapper objectMapper, String topicARN) {
        super(amazonSNS, objectMapper, topicARN);
    }

    @EventListener
    public void onFormTaggedEvent(FormTaggedEvent event) {
        LOGGER.info("Publishing event {} to SNS Topic {}", (Object)event, (Object)this.getTopicARN());
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>();
        attributes.put("tenantId", (MessageAttributeValue)MessageAttributeValue.builder().stringValue(event.getTenant().getId()).dataType("String").build());
        this.publish("FormTagged", event, attributes);
    }

    @EventListener
    public void onFormDeletedEvent(FormDeletedEvent event) {
        LOGGER.info("Publishing event {} to SNS Topic {}", (Object)event, (Object)this.getTopicARN());
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>();
        attributes.put("tenantId", (MessageAttributeValue)MessageAttributeValue.builder().stringValue(event.getTenant().getId()).dataType("String").build());
        this.publish("FormDeleted", event, attributes);
    }

    @EventListener
    public void onFormUpdatedEvent(FormUpdatedEvent event) {
        LOGGER.info("Publishing event {} to SNS Topic {}", (Object)event, (Object)this.getTopicARN());
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>();
        attributes.put("tenantId", (MessageAttributeValue)MessageAttributeValue.builder().stringValue(event.getTenant().getId()).dataType("String").build());
        this.publish("FormUpdated", event, attributes);
    }
}

