/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.cloud.aws.AbstractEventsToSNSBridge;
import io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;

public class DialobQuestionnaireEventsToSNSBridge
extends AbstractEventsToSNSBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobQuestionnaireEventsToSNSBridge.class);

    public DialobQuestionnaireEventsToSNSBridge(SnsAsyncClient amazonSNS, ObjectMapper objectMapper, String topicARN) {
        super(amazonSNS, objectMapper, topicARN);
    }

    @EventListener
    public void onQuestionnaireCompletedEvent(QuestionnaireCompletedEvent event) {
        LOGGER.info("Publishing event {} to SNS Topic {}", (Object)event, (Object)this.getTopicARN());
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>();
        attributes.put("tenantId", (MessageAttributeValue)MessageAttributeValue.builder().stringValue(event.getTenant().getId()).dataType("String").build());
        String subject = "QuestionnaireCompleted";
        this.publish(subject, event, attributes);
    }
}

