/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.aws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;

public class AbstractEventsToSNSBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventsToSNSBridge.class);
    private final SnsAsyncClient amazonSNS;
    private final String topicARN;
    private final ObjectMapper objectMapper;

    public AbstractEventsToSNSBridge(SnsAsyncClient amazonSNS, ObjectMapper objectMapper, String topicARN) {
        this.amazonSNS = amazonSNS;
        this.objectMapper = objectMapper;
        this.topicARN = topicARN;
    }

    protected void publish(String subject, Object message, Map<String, MessageAttributeValue> attributes) {
        try {
            PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().topicArn(this.topicARN).subject(subject).messageAttributes(attributes).message(this.objectMapper.writeValueAsString(message)).build();
            this.amazonSNS.publish(publishRequest).whenComplete((publishResponse, throwable) -> {
                LOGGER.debug("publish response: {}", publishResponse);
                if (throwable != null) {
                    LOGGER.error("Failed to publish", throwable);
                }
            });
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not publish event: {}", (Throwable)e);
        }
    }

    public String getTopicARN() {
        return this.topicARN;
    }
}

