/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.aws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dialob.questionnaire.service.api.AnswerSubmitHandler;
import io.dialob.questionnaire.service.submit.AbstractNormalizingPostSubmitHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class S3NormalizingPostSubmitHandler
extends AbstractNormalizingPostSubmitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3NormalizingPostSubmitHandler.class);
    private final ObjectMapper objectMapper;

    public S3NormalizingPostSubmitHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.copy().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    protected void sendDocument(AnswerSubmitHandler.Settings submitHandlerSettings, Map<String, Object> entries) {
        LOGGER.debug("sending {} to aws bucket {}", entries.get("_id"), submitHandlerSettings.getProperties().get("bucket"));
        Map properties = submitHandlerSettings.getProperties();
        S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)properties.getOrDefault("region", "eu-central-1")))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)((String)properties.get("accessKey")), (String)((String)properties.get("secretKey")))))).build();
        try {
            PutObjectResponse putObjectResponse = s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket((String)properties.get("bucket")).acl(ObjectCannedACL.PUBLIC_READ).key(entries.get("_id") + ".json").contentType("application/json").build(), RequestBody.fromBytes((byte[])this.objectMapper.writeValueAsBytes(entries)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("could not construct normalized document", (Throwable)e);
        }
    }
}

