/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cloud.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.cloud.aws.DialobFormEventsToSNSBridge;
import io.dialob.cloud.aws.DialobQuestionnaireEventsToSNSBridge;
import io.dialob.cloud.aws.S3NormalizingPostSubmitHandler;
import io.dialob.questionnaire.service.api.AnswerSubmitHandler;
import io.dialob.settings.DialobSettings;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="dialob.aws", name={"enabled"}, havingValue="true")
public class DialobCloudAwsAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobCloudAwsAutoConfiguration.class);

    @Bean(value={"S3SubmitHandler"})
    public AnswerSubmitHandler s3SubmitHandler(ObjectMapper objectMapper) {
        return new S3NormalizingPostSubmitHandler(objectMapper);
    }

    @Bean
    public SnsAsyncClient snsAsyncClient(Optional<AwsCredentialsProvider> credentialsProviderOptional, DialobSettings settings) {
        return credentialsProviderOptional.map(awsCredentialsProvider -> (SnsAsyncClient)((SnsAsyncClientBuilder)((SnsAsyncClientBuilder)SnsAsyncClient.builder().credentialsProvider(awsCredentialsProvider)).region(Region.EU_CENTRAL_1)).build()).orElseGet(() -> SnsAsyncClient.create());
    }

    @Bean
    public S3Client s3Client(Optional<AwsCredentialsProvider> credentialsProviderOptional, DialobSettings settings) {
        return credentialsProviderOptional.map(awsCredentialsProvider -> (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(awsCredentialsProvider)).region(Region.of((String)settings.getAws().getRegion()))).build()).orElseGet(() -> S3Client.create());
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.aws.sns", name={"formEventsTopicARN"})
    public DialobFormEventsToSNSBridge dialobFormEventsToSNSBridge(SnsAsyncClient client, ObjectMapper objectMapper, DialobSettings settings) {
        String topicARN = settings.getAws().getSns().getFormEventsTopicARN();
        LOGGER.info("Delegate form events to {}", (Object)topicARN);
        return new DialobFormEventsToSNSBridge(client, objectMapper, topicARN);
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.aws.sns", name={"questionnaireEventsTopicARN"})
    public DialobQuestionnaireEventsToSNSBridge dialobQuestionnaireEventsToSNSBridge(SnsAsyncClient client, ObjectMapper objectMapper, DialobSettings settings) {
        String topicARN = settings.getAws().getSns().getQuestionnaireEventsTopicARN();
        LOGGER.info("Delegate questionnaire events to {}", (Object)topicARN);
        return new DialobQuestionnaireEventsToSNSBridge(client, objectMapper, topicARN);
    }
}

