/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.support;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class RepositoryToStaticData {
    private final ClientState state;

    public RepositoryToStaticData(ClientState state) {
        this.state = state;
    }

    public String print(Repo repo) {
        HashMap replacements = new HashMap();
        Function<String, String> ID = id -> {
            if (replacements.containsKey(id)) {
                return (String)replacements.get(id);
            }
            String next = String.valueOf(replacements.size() + 1);
            replacements.put(id, next);
            return next;
        };
        ClientState.ClientRepoState ctx = this.state.withRepo(repo);
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator()).append("Repo").append(System.lineSeparator()).append("  - id: ").append(ID.apply(repo.getId())).append(", rev: ").append(ID.apply(repo.getRev())).append(System.lineSeparator()).append("    name: ").append(repo.getName()).append(System.lineSeparator());
        result.append(System.lineSeparator()).append("Refs").append(System.lineSeparator());
        ctx.query().refs().find().onItem().transform(item -> {
            result.append("  - ").append((String)ID.apply(item.getCommit())).append(": ").append(item.getName()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Tags").append(System.lineSeparator());
        ctx.query().tags().find().onItem().transform(item -> {
            result.append("  - id: ").append(item.getName()).append(System.lineSeparator()).append("    commit: ").append((String)ID.apply(item.getCommit())).append(", message: ").append(item.getMessage()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Commits").append(System.lineSeparator());
        ctx.query().commits().find().onItem().transform(item -> {
            result.append("  - id: ").append((String)ID.apply(item.getId())).append(System.lineSeparator()).append("    tree: ").append((String)ID.apply(item.getTree())).append(", parent: ").append(item.getParent().map(e -> (String)ID.apply((String)e)).orElse("")).append(", message: ").append(item.getMessage()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Trees").append(System.lineSeparator());
        ctx.query().trees().find().onItem().transform(src -> {
            ArrayList items = new ArrayList(src.getValues().values());
            items.sort(new Comparator<Objects.TreeValue>(){

                @Override
                public int compare(Objects.TreeValue o1, Objects.TreeValue o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            result.append("  - id: ").append((String)ID.apply(src.getId())).append(System.lineSeparator());
            for (Objects.TreeValue e : items) {
                result.append("    ").append((String)ID.apply(e.getBlob())).append(": ").append(e.getName()).append(System.lineSeparator());
            }
            return src;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Blobs").append(System.lineSeparator());
        ArrayList blobs = new ArrayList();
        ctx.query().blobs().find().onItem().transform(item -> {
            StringBuilder log = new StringBuilder().append("  - ").append((String)ID.apply(item.getId())).append(": ").append(RepositoryToStaticData.replaceContent(item.getValue(), replacements)).append(System.lineSeparator());
            blobs.add(log.toString());
            return item;
        }).collect().asList().await().indefinitely();
        blobs.stream().sorted().forEach(e -> result.append((String)e));
        return result.toString();
    }

    public static String replaceContent(String text, Map<String, String> replacements) {
        Object newText = text;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            int version = ((String)(newText = ((String)newText).replaceAll(entry.getKey(), entry.getValue()))).indexOf("\"version\":");
            if (version <= 1) continue;
            String trailer = ((String)newText).substring(version);
            int next = trailer.indexOf(",") + 1;
            newText = ((String)newText).substring(0, version) + trailer.substring(next);
        }
        if (((String)newText).length() > 100) {
            newText = ((String)newText).substring(0, 100) + "... cropped";
        }
        return newText;
    }

    public static String toString(Class<?> type, String resource) {
        try {
            return new String(type.getClassLoader().getResourceAsStream(resource).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

