/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.support;

import io.dialob.client.api.DialobErrorHandler;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public final class OidUtils {
    private static final SecureRandom SECURE_RANDOM;

    private OidUtils() {
    }

    @NotNull
    public static byte[] generateOID() {
        byte[] oid = new byte[16];
        SECURE_RANDOM.nextBytes(oid);
        return oid;
    }

    @NotNull
    public static String toString(@NotNull byte[] oid) {
        return Hex.encodeHexString((byte[])oid);
    }

    public static String gen() {
        return OidUtils.toString(OidUtils.generateOID());
    }

    @Nullable
    public static byte[] toOID(@Nullable String id) {
        if (id == null) {
            return null;
        }
        try {
            id = id.replace("-", "");
            byte[] oidBytes = Hex.decodeHex((char[])id.toCharArray());
            if (oidBytes.length > 16) {
                throw new DialobErrorHandler.DocumentNotFoundException(id + " is too long ID");
            }
            if (oidBytes.length < 16) {
                oidBytes = Arrays.copyOf(oidBytes, 16);
            }
            return oidBytes;
        }
        catch (DecoderException e) {
            throw new DialobErrorHandler.DocumentNotFoundException(id + " is not valid ID: " + e.getMessage());
        }
    }

    @Nullable
    static Integer validateRevValue(@Nullable String rev) {
        if (rev == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)rev) || !StringUtils.isNumeric((CharSequence)rev)) {
            throw new IllegalArgumentException("rev must be numeric");
        }
        return Integer.parseInt(rev);
    }

    static {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                secureRandom = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e1) {
                secureRandom = new SecureRandom();
            }
        }
        SECURE_RANDOM = secureRandom;
    }
}

