/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.support;

import io.dialob.client.api.DialobErrorHandler;
import java.util.function.Supplier;

public class DialobAssert {
    public static void notNull(Object object, Supplier<String> message) {
        if (object == null) {
            throw new DialobAssertException(DialobAssert.getMessage(message));
        }
    }

    public static void notEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            throw new DialobAssertException(DialobAssert.getMessage(message));
        }
    }

    public static void isTrue(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new DialobAssertException(DialobAssert.getMessage(message));
        }
    }

    private static String getMessage(Supplier<String> supplier) {
        return supplier != null ? supplier.get() : null;
    }

    public static class DialobAssertException
    extends IllegalArgumentException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 6305063707279384796L;

        public DialobAssertException(String s) {
            super(s);
        }
    }
}

