/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.store;

import io.dialob.client.api.DialobDocument;
import java.io.Serializable;

public class StoreEntityLocation
implements Serializable {
    private static final long serialVersionUID = -5312216893265396576L;
    private final String value;

    public StoreEntityLocation(String value) {
        this.value = value;
    }

    public String getAbsolutePath(DialobDocument.DocumentType type, String pointer) {
        return this.value + this.getFileName(type, pointer);
    }

    public String getFileName(DialobDocument.DocumentType type, String pointer) {
        return this.getPath(type) + "/" + pointer + ".json";
    }

    public String getBaseName(DialobDocument.DocumentType type, String filename) {
        return filename.substring(0, filename.lastIndexOf("."));
    }

    public String getFormRegex() {
        return this.withRegex("**/form/**/*.json");
    }

    public String getFormTagRegex() {
        return this.withRegex("**/formrev/**/*.json");
    }

    public String getMigrationRegex() {
        return this.withRegex("**/dialob_migration/**/*.txt");
    }

    public String getValue() {
        return this.value;
    }

    private String getPath(DialobDocument.DocumentType type) {
        switch (type) {
            case FORM: {
                return "form";
            }
            case FORM_REV: {
                return "formrev";
            }
        }
        throw new IllegalArgumentException("Unknown asset type:" + type + "!");
    }

    private String withRegex(String exp) {
        return this.value + exp;
    }
}

