/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.store;

import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreExceptionMsg;
import io.dialob.client.api.ImmutableStoreState;
import io.dialob.client.spi.exceptions.StoreException;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.dialob.client.spi.store.ImmutableEntityState;
import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class PersistenceCommands
implements DialobStoreConfig.Commands {
    protected final DialobStoreConfig config;

    public PersistenceCommands(DialobStoreConfig config) {
        this.config = config;
    }

    @Override
    public Uni<DialobStore.StoreEntity> delete(DialobStore.StoreEntity toBeDeleted) {
        return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("Delete type: '" + toBeDeleted.getBodyType() + "', with id: '" + toBeDeleted.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).remove(toBeDeleted.getId()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return toBeDeleted;
            }
            throw new StoreException("DELETE_FAIL", toBeDeleted, this.convertMessages((CommitActions.CommitResult)commit));
        });
    }

    @Override
    public Uni<DialobStore.StoreEntity> save(DialobStore.StoreEntity toBeSaved) {
        return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("Save type: '" + toBeSaved.getBodyType() + "', with id: '" + toBeSaved.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(toBeSaved.getId(), this.config.getSerializer().toString(toBeSaved)).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return toBeSaved;
            }
            throw new StoreException("SAVE_FAIL", toBeSaved, this.convertMessages((CommitActions.CommitResult)commit));
        });
    }

    @Override
    public Uni<Collection<DialobStore.StoreEntity>> save(Collection<DialobStore.StoreEntity> entities) {
        CommitActions.HeadCommitBuilder commitBuilder = this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName());
        DialobStore.StoreEntity first = entities.iterator().next();
        for (DialobStore.StoreEntity target : entities) {
            commitBuilder.append(target.getId(), this.config.getSerializer().toString(target));
        }
        return commitBuilder.message("Save type: '" + first.getBodyType() + "', with id: '" + first.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return entities;
            }
            throw new StoreException("SAVE_FAIL", null, this.convertMessages((CommitActions.CommitResult)commit));
        });
    }

    public DialobStore.StoreEntity getEntityFromState(DialobStore.StoreState state, String id) {
        DialobStore.StoreEntity entity = state.getForms().get(id);
        if (entity == null) {
            return state.getRevs().get(id);
        }
        return null;
    }

    @Override
    public Uni<DialobStore.StoreState> get() {
        return this.config.getClient().objects().refState().repo(this.config.getRepoName()).ref(this.config.getHeadName()).blobs().build().onItem().transform(state -> {
            if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                throw new StoreException("GET_REPO_STATE_FAIL", null, ImmutableStoreExceptionMsg.builder().id(state.getRepo().getName()).value(state.getRepo().getId()).addAllArgs(state.getMessages().stream().map(message -> message.getText()).collect(Collectors.toList())).build());
            }
            ImmutableStoreState.Builder builder = ImmutableStoreState.builder();
            if (state.getObjects() == null) {
                return builder.build();
            }
            Objects.Tree tree = ((ObjectsActions.RefObjects)state.getObjects()).getTree();
            block5: for (Map.Entry entry : tree.getValues().entrySet()) {
                String blobId = ((Objects.TreeValue)entry.getValue()).getBlob();
                Objects.Blob blob = (Objects.Blob)((ObjectsActions.RefObjects)state.getObjects()).getBlobs().get(blobId);
                DialobStore.StoreEntity entity = this.config.getDeserializer().fromString(blob);
                switch (entity.getBodyType()) {
                    case FORM: {
                        builder.putForms(entity.getId(), entity);
                        continue block5;
                    }
                    case FORM_REV: {
                        builder.putRevs(entity.getId(), entity);
                        continue block5;
                    }
                    case RELEASE: {
                        builder.putTags(entity.getId(), entity);
                        continue block5;
                    }
                }
                throw new RuntimeException("Unknown type: " + entity.getBodyType() + "!");
            }
            return builder.build();
        });
    }

    @Override
    public Uni<DialobStoreConfig.EntityState> getEntityState(String id) {
        return this.config.getClient().objects().blobState().repo(this.config.getRepoName()).anyId(this.config.getHeadName()).blobName(id).get().onItem().transform(state -> {
            if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                throw new StoreException("GET_FAIL", null, this.convertMessages1((ObjectsActions.ObjectsResult<ObjectsActions.BlobObject>)state));
            }
            DialobStore.StoreEntity start = this.config.getDeserializer().fromString(((ObjectsActions.BlobObject)state.getObjects()).getBlob());
            return ImmutableEntityState.builder().src((ObjectsActions.ObjectsResult<ObjectsActions.BlobObject>)state).entity(start).build();
        });
    }

    protected DialobStore.StoreExceptionMsg convertMessages(CommitActions.CommitResult commit) {
        return ImmutableStoreExceptionMsg.builder().id(commit.getGid()).value("").addAllArgs(commit.getMessages().stream().map(message -> message.getText()).collect(Collectors.toList())).build();
    }

    protected DialobStore.StoreExceptionMsg convertMessages1(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> state) {
        return ImmutableStoreExceptionMsg.builder().id("RUNTIME_ERROR").value("").addAllArgs(state.getMessages().stream().map(message -> message.getText()).collect(Collectors.toList())).build();
    }

    protected DialobStore.StoreExceptionMsg convertMessages2(ObjectsActions.ObjectsResult<ObjectsActions.BlobObjects> state) {
        return ImmutableStoreExceptionMsg.builder().id("RUNTIME_ERROR").value("").addAllArgs(state.getMessages().stream().map(message -> message.getText()).collect(Collectors.toList())).build();
    }

    public DialobStoreConfig getConfig() {
        return this.config;
    }
}

