/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.store;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobStore;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStoreConfig.EntityState", generator="Immutables")
@Immutable
public final class ImmutableEntityState
implements DialobStoreConfig.EntityState {
    private final ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src;
    private final DialobStore.StoreEntity entity;

    private ImmutableEntityState(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src, DialobStore.StoreEntity entity) {
        this.src = src;
        this.entity = entity;
    }

    @Override
    public ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> getSrc() {
        return this.src;
    }

    @Override
    public DialobStore.StoreEntity getEntity() {
        return this.entity;
    }

    public final ImmutableEntityState withSrc(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> value) {
        if (this.src == value) {
            return this;
        }
        ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> newValue = Objects.requireNonNull(value, "src");
        return new ImmutableEntityState(newValue, this.entity);
    }

    public final ImmutableEntityState withEntity(DialobStore.StoreEntity value) {
        if (this.entity == value) {
            return this;
        }
        DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "entity");
        return new ImmutableEntityState(this.src, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntityState && this.equalTo((ImmutableEntityState)another);
    }

    private boolean equalTo(ImmutableEntityState another) {
        return this.src.equals(another.src) && this.entity.equals(another.entity);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.src.hashCode();
        h += (h << 5) + this.entity.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityState").omitNullValues().add("src", this.src).add("entity", (Object)this.entity).toString();
    }

    public static ImmutableEntityState copyOf(DialobStoreConfig.EntityState instance) {
        if (instance instanceof ImmutableEntityState) {
            return (ImmutableEntityState)instance;
        }
        return ImmutableEntityState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStoreConfig.EntityState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SRC = 1L;
        private static final long INIT_BIT_ENTITY = 2L;
        private long initBits = 3L;
        @Nullable
        private ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src;
        @Nullable
        private DialobStore.StoreEntity entity;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStoreConfig.EntityState instance) {
            Objects.requireNonNull(instance, "instance");
            this.src(instance.getSrc());
            this.entity(instance.getEntity());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder src(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src) {
            this.src = Objects.requireNonNull(src, "src");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entity(DialobStore.StoreEntity entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEntityState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntityState(this.src, this.entity);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("src");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("entity");
            }
            return "Cannot build EntityState, some of required attributes are not set " + attributes;
        }
    }
}

