/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.store;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.resys.thena.docdb.api.DocDB;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStoreConfig", generator="Immutables")
@Immutable
public final class ImmutableDialobStoreConfig
implements DialobStoreConfig {
    private final DocDB client;
    private final String repoName;
    private final String headName;
    private final DialobStoreConfig.AuthorProvider authorProvider;
    private final DialobStoreConfig.GidProvider gidProvider;
    private final DialobStoreConfig.Serializer serializer;
    private final DialobStoreConfig.Deserializer deserializer;

    private ImmutableDialobStoreConfig(DocDB client, String repoName, String headName, DialobStoreConfig.AuthorProvider authorProvider, DialobStoreConfig.GidProvider gidProvider, DialobStoreConfig.Serializer serializer, DialobStoreConfig.Deserializer deserializer) {
        this.client = client;
        this.repoName = repoName;
        this.headName = headName;
        this.authorProvider = authorProvider;
        this.gidProvider = gidProvider;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    public DocDB getClient() {
        return this.client;
    }

    @Override
    public String getRepoName() {
        return this.repoName;
    }

    @Override
    public String getHeadName() {
        return this.headName;
    }

    @Override
    public DialobStoreConfig.AuthorProvider getAuthorProvider() {
        return this.authorProvider;
    }

    @Override
    public DialobStoreConfig.GidProvider getGidProvider() {
        return this.gidProvider;
    }

    @Override
    public DialobStoreConfig.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public DialobStoreConfig.Deserializer getDeserializer() {
        return this.deserializer;
    }

    public final ImmutableDialobStoreConfig withClient(DocDB value) {
        if (this.client == value) {
            return this;
        }
        DocDB newValue = Objects.requireNonNull(value, "client");
        return new ImmutableDialobStoreConfig(newValue, this.repoName, this.headName, this.authorProvider, this.gidProvider, this.serializer, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withRepoName(String value) {
        String newValue = Objects.requireNonNull(value, "repoName");
        if (this.repoName.equals(newValue)) {
            return this;
        }
        return new ImmutableDialobStoreConfig(this.client, newValue, this.headName, this.authorProvider, this.gidProvider, this.serializer, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withHeadName(String value) {
        String newValue = Objects.requireNonNull(value, "headName");
        if (this.headName.equals(newValue)) {
            return this;
        }
        return new ImmutableDialobStoreConfig(this.client, this.repoName, newValue, this.authorProvider, this.gidProvider, this.serializer, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withAuthorProvider(DialobStoreConfig.AuthorProvider value) {
        if (this.authorProvider == value) {
            return this;
        }
        DialobStoreConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
        return new ImmutableDialobStoreConfig(this.client, this.repoName, this.headName, newValue, this.gidProvider, this.serializer, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withGidProvider(DialobStoreConfig.GidProvider value) {
        if (this.gidProvider == value) {
            return this;
        }
        DialobStoreConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
        return new ImmutableDialobStoreConfig(this.client, this.repoName, this.headName, this.authorProvider, newValue, this.serializer, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withSerializer(DialobStoreConfig.Serializer value) {
        if (this.serializer == value) {
            return this;
        }
        DialobStoreConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
        return new ImmutableDialobStoreConfig(this.client, this.repoName, this.headName, this.authorProvider, this.gidProvider, newValue, this.deserializer);
    }

    public final ImmutableDialobStoreConfig withDeserializer(DialobStoreConfig.Deserializer value) {
        if (this.deserializer == value) {
            return this;
        }
        DialobStoreConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
        return new ImmutableDialobStoreConfig(this.client, this.repoName, this.headName, this.authorProvider, this.gidProvider, this.serializer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialobStoreConfig && this.equalTo((ImmutableDialobStoreConfig)another);
    }

    private boolean equalTo(ImmutableDialobStoreConfig another) {
        return this.client.equals(another.client) && this.repoName.equals(another.repoName) && this.headName.equals(another.headName) && this.authorProvider.equals(another.authorProvider) && this.gidProvider.equals(another.gidProvider) && this.serializer.equals(another.serializer) && this.deserializer.equals(another.deserializer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.repoName.hashCode();
        h += (h << 5) + this.headName.hashCode();
        h += (h << 5) + this.authorProvider.hashCode();
        h += (h << 5) + this.gidProvider.hashCode();
        h += (h << 5) + this.serializer.hashCode();
        h += (h << 5) + this.deserializer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DialobStoreConfig").omitNullValues().add("client", (Object)this.client).add("repoName", (Object)this.repoName).add("headName", (Object)this.headName).add("authorProvider", (Object)this.authorProvider).add("gidProvider", (Object)this.gidProvider).add("serializer", (Object)this.serializer).add("deserializer", (Object)this.deserializer).toString();
    }

    public static ImmutableDialobStoreConfig copyOf(DialobStoreConfig instance) {
        if (instance instanceof ImmutableDialobStoreConfig) {
            return (ImmutableDialobStoreConfig)instance;
        }
        return ImmutableDialobStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private static final long INIT_BIT_REPO_NAME = 2L;
        private static final long INIT_BIT_HEAD_NAME = 4L;
        private static final long INIT_BIT_AUTHOR_PROVIDER = 8L;
        private static final long INIT_BIT_GID_PROVIDER = 16L;
        private static final long INIT_BIT_SERIALIZER = 32L;
        private static final long INIT_BIT_DESERIALIZER = 64L;
        private long initBits = 127L;
        @Nullable
        private DocDB client;
        @Nullable
        private String repoName;
        @Nullable
        private String headName;
        @Nullable
        private DialobStoreConfig.AuthorProvider authorProvider;
        @Nullable
        private DialobStoreConfig.GidProvider gidProvider;
        @Nullable
        private DialobStoreConfig.Serializer serializer;
        @Nullable
        private DialobStoreConfig.Deserializer deserializer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.getClient());
            this.repoName(instance.getRepoName());
            this.headName(instance.getHeadName());
            this.authorProvider(instance.getAuthorProvider());
            this.gidProvider(instance.getGidProvider());
            this.serializer(instance.getSerializer());
            this.deserializer(instance.getDeserializer());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DocDB client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoName(String repoName) {
            this.repoName = Objects.requireNonNull(repoName, "repoName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headName(String headName) {
            this.headName = Objects.requireNonNull(headName, "headName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorProvider(DialobStoreConfig.AuthorProvider authorProvider) {
            this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gidProvider(DialobStoreConfig.GidProvider gidProvider) {
            this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serializer(DialobStoreConfig.Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer, "serializer");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deserializer(DialobStoreConfig.Deserializer deserializer) {
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableDialobStoreConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialobStoreConfig(this.client, this.repoName, this.headName, this.authorProvider, this.gidProvider, this.serializer, this.deserializer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repoName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("headName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("authorProvider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("gidProvider");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("serializer");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("deserializer");
            }
            return "Cannot build DialobStoreConfig, some of required attributes are not set " + attributes;
        }
    }
}

