/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.store;

import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import java.util.Collection;
import org.immutables.value.Value;

@Value.Immutable
public interface DialobStoreConfig {
    public DocDB getClient();

    public String getRepoName();

    public String getHeadName();

    public AuthorProvider getAuthorProvider();

    public GidProvider getGidProvider();

    public Serializer getSerializer();

    public Deserializer getDeserializer();

    public static interface Commands {
        public Uni<DialobStore.StoreEntity> delete(DialobStore.StoreEntity var1);

        public Uni<DialobStore.StoreState> get();

        public Uni<EntityState> getEntityState(String var1);

        public Uni<DialobStore.StoreEntity> save(DialobStore.StoreEntity var1);

        public Uni<Collection<DialobStore.StoreEntity>> save(Collection<DialobStore.StoreEntity> var1);
    }

    @Value.Immutable
    public static interface EntityState {
        public ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> getSrc();

        public DialobStore.StoreEntity getEntity();
    }

    @FunctionalInterface
    public static interface AuthorProvider {
        public String getAuthor();
    }

    public static interface Deserializer {
        public DialobStore.StoreEntity fromString(Objects.Blob var1);
    }

    @FunctionalInterface
    public static interface Serializer {
        public String toString(DialobStore.StoreEntity var1);
    }

    @FunctionalInterface
    public static interface GidProvider {
        public String getNextId(DialobDocument.DocumentType var1);
    }
}

