/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.program;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.compiler.DialobProgramFromFormCompiler;
import io.dialob.program.DialobProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramBuilderImpl
implements DialobClient.ProgramBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramBuilderImpl.class);
    private final DialobProgramFromFormCompiler compiler;
    private DialobDocument.FormDocument form;

    @Override
    public DialobClient.ProgramBuilder form(DialobDocument.FormDocument form) {
        this.form = form;
        return this;
    }

    @Override
    public DialobProgram build() {
        DialobAssert.notNull(this.form, () -> "form can't be null!");
        LOGGER.debug("Compiling form document {} rev {}", (Object)this.form.getData().getId(), (Object)this.form.getData().getRev());
        return this.compiler.compileForm(this.form.getData());
    }

    public ProgramBuilderImpl(DialobProgramFromFormCompiler compiler) {
        this.compiler = compiler;
    }
}

