/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.program;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.spi.support.DialobAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImmutableProgramEnvir
implements DialobClient.ProgramEnvir {
    private final Map<String, List<DialobClient.ProgramWrapper>> byFormId;
    private final Map<String, DialobClient.RevisionWrapper> byId;

    @Override
    public Map<String, DialobClient.ProgramEnvirValue<?>> getValues() {
        HashMap result = new HashMap(this.byId);
        this.byFormId.values().stream().flatMap(e -> e.stream()).forEach(e -> result.put(((DialobDocument.FormDocument)e.getDocument()).getId(), (DialobClient.ProgramEnvirValue<?>)e));
        return result;
    }

    @Override
    public DialobClient.ProgramWrapper findByFormId(String formId) {
        if (!this.byFormId.containsKey(formId)) {
            String ids = String.join((CharSequence)",", this.byFormId.keySet());
            throw new ProgramNotFoundFromEnvir("No program by formId: '" + formId + "', known forms: '" + ids + "'!");
        }
        List<DialobClient.ProgramWrapper> values = this.byFormId.get(formId);
        if (values.size() > 1) {
            String revs = String.join((CharSequence)",", values.stream().map(e -> ((DialobDocument.FormDocument)e.getDocument()).getData().getRev()).collect(Collectors.toList()));
            throw new ProgramHasMultipleRevs("Program by formId: '" + formId + "' requires rev because of multpile revisions in use: '" + revs + "'!");
        }
        return values.get(0);
    }

    @Override
    public DialobClient.ProgramWrapper findByFormIdAndRev(String formId, String formRev) {
        List byCreated;
        Optional<DialobClient.ProgramWrapper> fallback1;
        if (formRev == null) {
            return this.findByFormId(formId);
        }
        if (!this.byFormId.containsKey(formId)) {
            String ids = String.join((CharSequence)",", this.byFormId.keySet());
            throw new ProgramNotFoundFromEnvir("No program by formId: '" + formId + "', known forms: '" + ids + "'!");
        }
        List<DialobClient.ProgramWrapper> values = this.byFormId.get(formId);
        Optional<Object> result = "LATEST".equals(formRev) ? ((fallback1 = values.stream().filter(r -> formRev.equals(((DialobDocument.FormDocument)r.getDocument()).getData().getRev())).findFirst()).isEmpty() ? Optional.ofNullable((byCreated = values.stream().sorted((b, a) -> ((DialobDocument.FormDocument)a.getDocument()).getData().getMetadata().getCreated().compareTo(((DialobDocument.FormDocument)b.getDocument()).getData().getMetadata().getCreated())).collect(Collectors.toList())).isEmpty() ? null : (DialobClient.ProgramWrapper)byCreated.get(0)) : fallback1) : values.stream().filter(r -> formRev.equals(((DialobDocument.FormDocument)r.getDocument()).getData().getRev())).findFirst();
        if (result.isEmpty()) {
            String revs = String.join((CharSequence)",", values.stream().map(e -> ((DialobDocument.FormDocument)e.getDocument()).getData().getRev()).collect(Collectors.toList()));
            throw new ProgramRevNotFound("Program by formId: '" + formId + "' revision: '" + formRev + "' not found, revisions in use: '" + revs + "'!");
        }
        return result.get();
    }

    @Override
    public List<DialobClient.ProgramWrapper> findAll() {
        return this.byFormId.values().stream().flatMap(e -> e.stream()).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public ImmutableProgramEnvir(Map<String, List<DialobClient.ProgramWrapper>> byFormId, Map<String, DialobClient.RevisionWrapper> byId) {
        this.byFormId = byFormId;
        this.byId = byId;
    }

    public static class ProgramRevNotFound
    extends DialobErrorHandler.DocumentNotFoundException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 6305063707279384796L;

        public ProgramRevNotFound(String s) {
            super(s);
        }
    }

    public static class ProgramHasMultipleRevs
    extends IllegalArgumentException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 6305063707279384796L;

        public ProgramHasMultipleRevs(String s) {
            super(s);
        }
    }

    public static class ProgramNotFoundFromEnvir
    extends DialobErrorHandler.DocumentNotFoundException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 6305063707279384796L;

        public ProgramNotFoundFromEnvir(String s) {
            super(s);
        }
    }

    public static class Builder {
        private final Map<String, List<DialobClient.ProgramWrapper>> byFormId = new HashMap<String, List<DialobClient.ProgramWrapper>>();
        private final Map<String, DialobClient.RevisionWrapper> revsById = new HashMap<String, DialobClient.RevisionWrapper>();
        private final Map<String, DialobClient.ReleaseWrapper> relsById = new HashMap<String, DialobClient.ReleaseWrapper>();

        public Builder add(DialobClient.ProgramEnvirValue<?> wrapper) {
            if (wrapper instanceof DialobClient.RevisionWrapper) {
                DialobAssert.isTrue(!this.revsById.containsKey(wrapper.getDocument().getId()), () -> "Can't redfined revision document with id: '" + wrapper.getDocument().getId() + "'");
                this.revsById.put(wrapper.getDocument().getId(), (DialobClient.RevisionWrapper)wrapper);
            } else if (wrapper instanceof DialobClient.ProgramWrapper) {
                DialobClient.ProgramWrapper program = (DialobClient.ProgramWrapper)wrapper;
                DialobDocument.FormDocument form = (DialobDocument.FormDocument)program.getDocument();
                List revs = Optional.ofNullable(this.byFormId.get(form.getData().getId())).orElseGet(() -> {
                    ArrayList values = new ArrayList();
                    this.byFormId.put(form.getData().getId(), values);
                    return values;
                });
                revs.add(program);
            } else {
                this.relsById.put(wrapper.getDocument().getId(), (DialobClient.ReleaseWrapper)wrapper);
            }
            return this;
        }

        public DialobClient.ProgramEnvir build() {
            return new ImmutableProgramEnvir(Collections.unmodifiableMap(this.byFormId), Collections.unmodifiableMap(this.revsById));
        }
    }
}

