/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.migration;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.spi.support.Sha2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

public class MigrationSupport {
    private static Charset UTF_8 = StandardCharsets.UTF_8;
    private static String BEGIN = "-----BEGIN RELEASE JSON GZIP BASE64-----\r\n";
    private static String END = "-----END RELEASE JSON GZIP BASE64-----";
    private final DialobClient.TypesMapper config;

    public MigrationContent read(InputStream input) {
        try {
            String content = new String(input.readAllBytes(), UTF_8);
            content = content.substring(content.indexOf(BEGIN) + BEGIN.length(), content.indexOf(END));
            Base64InputStream b64os = new Base64InputStream((InputStream)new ByteArrayInputStream(content.getBytes(UTF_8)));
            GZIPInputStream gzip = new GZIPInputStream((InputStream)b64os);
            String doc = new String(gzip.readAllBytes(), UTF_8);
            return MigrationContent.builder().release(this.config.readReleaseDoc(doc)).hash(Sha2.blob(doc)).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Migration migration, OutputStream output) {
        try {
            try {
                String json = this.config.toJson(migration.getRelease());
                String hash = Sha2.blob(json);
                migration.setHash(hash);
                byte[] toCompress = json.getBytes(UTF_8);
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                Base64OutputStream b64os = new Base64OutputStream((OutputStream)byteArray);
                GZIPOutputStream zipStream = new GZIPOutputStream((OutputStream)b64os);
                zipStream.write(toCompress);
                zipStream.close();
                b64os.close();
                byteArray.close();
                byte[] compressed = byteArray.toByteArray();
                output.write(migration.getLog().getBytes(UTF_8));
                output.write((System.lineSeparator() + System.lineSeparator()).getBytes(UTF_8));
                output.write(("Content hash: " + hash + System.lineSeparator()).getBytes(UTF_8));
                output.write(BEGIN.getBytes(UTF_8));
                output.write(compressed);
                output.write((END + System.lineSeparator()).getBytes(UTF_8));
                output.flush();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public MigrationSupport(DialobClient.TypesMapper config) {
        this.config = config;
    }

    public static class MigrationContent {
        private DialobDocument.FormReleaseDocument release;
        private String hash;

        MigrationContent(DialobDocument.FormReleaseDocument release, String hash) {
            this.release = release;
            this.hash = hash;
        }

        public static MigrationContentBuilder builder() {
            return new MigrationContentBuilder();
        }

        public DialobDocument.FormReleaseDocument getRelease() {
            return this.release;
        }

        public String getHash() {
            return this.hash;
        }

        public void setRelease(DialobDocument.FormReleaseDocument release) {
            this.release = release;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrationContent)) {
                return false;
            }
            MigrationContent other = (MigrationContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DialobDocument.FormReleaseDocument this$release = this.getRelease();
            DialobDocument.FormReleaseDocument other$release = other.getRelease();
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MigrationContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DialobDocument.FormReleaseDocument $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        public String toString() {
            return "MigrationSupport.MigrationContent(release=" + this.getRelease() + ", hash=" + this.getHash() + ")";
        }

        public static class MigrationContentBuilder {
            private DialobDocument.FormReleaseDocument release;
            private String hash;

            MigrationContentBuilder() {
            }

            public MigrationContentBuilder release(DialobDocument.FormReleaseDocument release) {
                this.release = release;
                return this;
            }

            public MigrationContentBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public MigrationContent build() {
                return new MigrationContent(this.release, this.hash);
            }

            public String toString() {
                return "MigrationSupport.MigrationContent.MigrationContentBuilder(release=" + this.release + ", hash=" + this.hash + ")";
            }
        }
    }

    public static class Migration {
        private DialobDocument.FormReleaseDocument release;
        private String log;
        private String hash;

        Migration(DialobDocument.FormReleaseDocument release, String log, String hash) {
            this.release = release;
            this.log = log;
            this.hash = hash;
        }

        public static MigrationBuilder builder() {
            return new MigrationBuilder();
        }

        public DialobDocument.FormReleaseDocument getRelease() {
            return this.release;
        }

        public String getLog() {
            return this.log;
        }

        public String getHash() {
            return this.hash;
        }

        public void setRelease(DialobDocument.FormReleaseDocument release) {
            this.release = release;
        }

        public void setLog(String log) {
            this.log = log;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Migration)) {
                return false;
            }
            Migration other = (Migration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DialobDocument.FormReleaseDocument this$release = this.getRelease();
            DialobDocument.FormReleaseDocument other$release = other.getRelease();
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            String this$log = this.getLog();
            String other$log = other.getLog();
            if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Migration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DialobDocument.FormReleaseDocument $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            String $log = this.getLog();
            result = result * 59 + ($log == null ? 43 : $log.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        public String toString() {
            return "MigrationSupport.Migration(release=" + this.getRelease() + ", log=" + this.getLog() + ", hash=" + this.getHash() + ")";
        }

        public static class MigrationBuilder {
            private DialobDocument.FormReleaseDocument release;
            private String log;
            private String hash;

            MigrationBuilder() {
            }

            public MigrationBuilder release(DialobDocument.FormReleaseDocument release) {
                this.release = release;
                return this;
            }

            public MigrationBuilder log(String log) {
                this.log = log;
                return this;
            }

            public MigrationBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public Migration build() {
                return new Migration(this.release, this.log, this.hash);
            }

            public String toString() {
                return "MigrationSupport.Migration.MigrationBuilder(release=" + this.release + ", log=" + this.log + ", hash=" + this.hash + ")";
            }
        }
    }
}

