/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.function;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.function.ConfiguredFunction;
import io.dialob.rule.parser.api.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfiguredFunction", generator="Immutables")
@Immutable
final class ImmutableConfiguredFunction
implements ConfiguredFunction {
    private final String functionName;
    private final String staticMethodName;
    private final ValueType returnType;
    private final ImmutableList<ValueType> argumentValueTypes;
    private final Predicate<ValueType[]> argumentMatcher;
    private final Class<?>[] argumentTypes;
    private final Class functionImplementationClass;
    private final boolean isAsync;

    private ImmutableConfiguredFunction(Builder builder) {
        this.functionName = builder.functionName;
        this.staticMethodName = builder.staticMethodName;
        this.returnType = builder.returnType;
        this.argumentValueTypes = builder.argumentValueTypes.build();
        this.argumentTypes = builder.argumentTypes;
        this.functionImplementationClass = builder.functionImplementationClass;
        this.isAsync = builder.isAsync;
        this.argumentMatcher = builder.argumentMatcher != null ? builder.argumentMatcher : Objects.requireNonNull(ConfiguredFunction.super.getArgumentMatcher(), "argumentMatcher");
    }

    private ImmutableConfiguredFunction(String functionName, String staticMethodName, ValueType returnType, ImmutableList<ValueType> argumentValueTypes, Predicate<ValueType[]> argumentMatcher, Class<?>[] argumentTypes, Class functionImplementationClass, boolean isAsync) {
        this.functionName = functionName;
        this.staticMethodName = staticMethodName;
        this.returnType = returnType;
        this.argumentValueTypes = argumentValueTypes;
        this.argumentMatcher = argumentMatcher;
        this.argumentTypes = argumentTypes;
        this.functionImplementationClass = functionImplementationClass;
        this.isAsync = isAsync;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getStaticMethodName() {
        return this.staticMethodName;
    }

    @Override
    public ValueType getReturnType() {
        return this.returnType;
    }

    public ImmutableList<ValueType> getArgumentValueTypes() {
        return this.argumentValueTypes;
    }

    @Override
    public Predicate<ValueType[]> getArgumentMatcher() {
        return this.argumentMatcher;
    }

    @Override
    public Class<?>[] getArgumentTypes() {
        return (Class[])this.argumentTypes.clone();
    }

    @Override
    public Class getFunctionImplementationClass() {
        return this.functionImplementationClass;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    public final ImmutableConfiguredFunction withFunctionName(String value) {
        String newValue = Objects.requireNonNull(value, "functionName");
        if (this.functionName.equals(newValue)) {
            return this;
        }
        return new ImmutableConfiguredFunction(newValue, this.staticMethodName, this.returnType, this.argumentValueTypes, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withStaticMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "staticMethodName");
        if (this.staticMethodName.equals(newValue)) {
            return this;
        }
        return new ImmutableConfiguredFunction(this.functionName, newValue, this.returnType, this.argumentValueTypes, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withReturnType(ValueType value) {
        if (this.returnType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "returnType");
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, newValue, this.argumentValueTypes, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withArgumentValueTypes(ValueType ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, (ImmutableList<ValueType>)newValue, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withArgumentValueTypes(Iterable<? extends ValueType> elements) {
        if (this.argumentValueTypes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, (ImmutableList<ValueType>)newValue, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withArgumentMatcher(Predicate<ValueType[]> value) {
        if (this.argumentMatcher == value) {
            return this;
        }
        Predicate<ValueType[]> newValue = Objects.requireNonNull(value, "argumentMatcher");
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, this.argumentValueTypes, newValue, this.argumentTypes, this.functionImplementationClass, this.isAsync);
    }

    @SafeVarargs
    public final ImmutableConfiguredFunction withArgumentTypes(Class<?> ... elements) {
        Class[] newValue = (Class[])elements.clone();
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, this.argumentValueTypes, this.argumentMatcher, newValue, this.functionImplementationClass, this.isAsync);
    }

    public final ImmutableConfiguredFunction withFunctionImplementationClass(Class value) {
        if (this.functionImplementationClass == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "functionImplementationClass");
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, this.argumentValueTypes, this.argumentMatcher, this.argumentTypes, newValue, this.isAsync);
    }

    public final ImmutableConfiguredFunction withIsAsync(boolean value) {
        if (this.isAsync == value) {
            return this;
        }
        return new ImmutableConfiguredFunction(this.functionName, this.staticMethodName, this.returnType, this.argumentValueTypes, this.argumentMatcher, this.argumentTypes, this.functionImplementationClass, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfiguredFunction && this.equalTo((ImmutableConfiguredFunction)another);
    }

    private boolean equalTo(ImmutableConfiguredFunction another) {
        return this.functionName.equals(another.functionName) && this.staticMethodName.equals(another.staticMethodName) && this.returnType.equals(another.returnType) && this.argumentValueTypes.equals(another.argumentValueTypes) && this.argumentMatcher.equals(another.argumentMatcher) && Arrays.equals(this.argumentTypes, another.argumentTypes) && this.functionImplementationClass.equals(another.functionImplementationClass) && this.isAsync == another.isAsync;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.functionName.hashCode();
        h += (h << 5) + this.staticMethodName.hashCode();
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.argumentValueTypes.hashCode();
        h += (h << 5) + this.argumentMatcher.hashCode();
        h += (h << 5) + Arrays.hashCode(this.argumentTypes);
        h += (h << 5) + this.functionImplementationClass.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isAsync);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConfiguredFunction").omitNullValues().add("functionName", (Object)this.functionName).add("staticMethodName", (Object)this.staticMethodName).add("returnType", (Object)this.returnType).add("argumentValueTypes", this.argumentValueTypes).add("argumentMatcher", this.argumentMatcher).add("argumentTypes", (Object)Arrays.toString(this.argumentTypes)).add("functionImplementationClass", (Object)this.functionImplementationClass).add("isAsync", this.isAsync).toString();
    }

    public static ImmutableConfiguredFunction copyOf(ConfiguredFunction instance) {
        if (instance instanceof ImmutableConfiguredFunction) {
            return (ImmutableConfiguredFunction)instance;
        }
        return ImmutableConfiguredFunction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfiguredFunction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FUNCTION_NAME = 1L;
        private static final long INIT_BIT_STATIC_METHOD_NAME = 2L;
        private static final long INIT_BIT_RETURN_TYPE = 4L;
        private static final long INIT_BIT_ARGUMENT_TYPES = 8L;
        private static final long INIT_BIT_FUNCTION_IMPLEMENTATION_CLASS = 16L;
        private static final long INIT_BIT_IS_ASYNC = 32L;
        private long initBits = 63L;
        @Nullable
        private String functionName;
        @Nullable
        private String staticMethodName;
        @Nullable
        private ValueType returnType;
        private ImmutableList.Builder<ValueType> argumentValueTypes = ImmutableList.builder();
        @Nullable
        private Predicate<ValueType[]> argumentMatcher;
        @Nullable
        private Class<?>[] argumentTypes;
        @Nullable
        private Class functionImplementationClass;
        private boolean isAsync;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConfiguredFunction instance) {
            Objects.requireNonNull(instance, "instance");
            this.functionName(instance.getFunctionName());
            this.staticMethodName(instance.getStaticMethodName());
            this.returnType(instance.getReturnType());
            this.addAllArgumentValueTypes(instance.getArgumentValueTypes());
            this.argumentMatcher(instance.getArgumentMatcher());
            this.argumentTypes(instance.getArgumentTypes());
            this.functionImplementationClass(instance.getFunctionImplementationClass());
            this.isAsync(instance.isAsync());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder functionName(String functionName) {
            this.functionName = Objects.requireNonNull(functionName, "functionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder staticMethodName(String staticMethodName) {
            this.staticMethodName = Objects.requireNonNull(staticMethodName, "staticMethodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnType(ValueType returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgumentValueTypes(ValueType element) {
            this.argumentValueTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgumentValueTypes(ValueType ... elements) {
            this.argumentValueTypes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder argumentValueTypes(Iterable<? extends ValueType> elements) {
            this.argumentValueTypes = ImmutableList.builder();
            return this.addAllArgumentValueTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArgumentValueTypes(Iterable<? extends ValueType> elements) {
            this.argumentValueTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder argumentMatcher(Predicate<ValueType[]> argumentMatcher) {
            this.argumentMatcher = Objects.requireNonNull(argumentMatcher, "argumentMatcher");
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder argumentTypes(Class<?> ... argumentTypes) {
            this.argumentTypes = (Class[])argumentTypes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder functionImplementationClass(Class functionImplementationClass) {
            this.functionImplementationClass = Objects.requireNonNull(functionImplementationClass, "functionImplementationClass");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isAsync(boolean isAsync) {
            this.isAsync = isAsync;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableConfiguredFunction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfiguredFunction(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("functionName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("staticMethodName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("returnType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("argumentTypes");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("functionImplementationClass");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isAsync");
            }
            return "Cannot build ConfiguredFunction, some of required attributes are not set " + attributes;
        }
    }
}

