/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.function;

import io.dialob.rule.parser.api.ValueType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@Value.Immutable
interface ConfiguredFunction {
    public String getFunctionName();

    public String getStaticMethodName();

    public ValueType getReturnType();

    public List<ValueType> getArgumentValueTypes();

    @Value.Default
    default public Predicate<ValueType[]> getArgumentMatcher() {
        return argTypes -> this.getArgumentValueTypes().equals(Arrays.asList(argTypes));
    }

    public Class<?>[] getArgumentTypes();

    public Class getFunctionImplementationClass();

    public boolean isAsync();

    default public boolean doesMatch(String canonicalFunctionName, Object ... args) {
        if (StringUtils.equalsAny((CharSequence)canonicalFunctionName, (CharSequence[])new CharSequence[]{this.getFunctionName(), this.getCanonicalName()})) {
            Class<?>[] argumentTypes = this.getArgumentTypes();
            for (int i = 0; i < args.length; ++i) {
                if (argumentTypes.length >= i && (args[i] == null || argumentTypes[i].isAssignableFrom(args[i].getClass()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public String getCanonicalName() {
        return this.getFunctionImplementationClass().getCanonicalName() + "." + this.getStaticMethodName();
    }
}

