/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.function;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.executor.model.IdUtils;
import io.dialob.executor.model.ItemId;
import io.dialob.program.EvalContext;
import io.dialob.rule.parser.function.FunctionRegistry;
import java.util.Collections;
import javax.annotation.Nonnull;

public class AsyncFunctionInvoker {
    private final FunctionRegistry registry;

    public EvalContext.UpdatedItemsVisitor.AsyncFunctionCallVisitor createVisitor(QuestionnaireSession session) {
        return asyncFunctionCall -> {
            AsyncFunctionCallback callback = new AsyncFunctionCallback(session, IdUtils.toString((ItemId)((ItemId)asyncFunctionCall.getTargetId().get())));
            String functionName = asyncFunctionCall.getFunctionName();
            Object[] args = asyncFunctionCall.getArgs();
            this.registry.invokeFunctionAsync((FunctionRegistry.FunctionCallback)callback, functionName, args);
        };
    }

    public AsyncFunctionInvoker(FunctionRegistry registry) {
        this.registry = registry;
    }

    private static class AsyncFunctionCallback
    implements FunctionRegistry.FunctionCallback {
        private final QuestionnaireSession session;
        private final String targetId;

        public void succeeded(Object result) {
            Action action = ActionsFactory.setValue((String)this.targetId, (Object)result);
            this.session.dispatchActions(Collections.singletonList(action));
        }

        public void failed(@Nonnull String error) {
            Action action = ActionsFactory.setValue((String)this.targetId, (Object)error);
            this.session.dispatchActions(Collections.singletonList(action));
        }

        public AsyncFunctionCallback(QuestionnaireSession session, String targetId) {
            this.session = session;
            this.targetId = targetId;
        }
    }
}

