/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.form;

import io.dialob.api.proto.ActionItem;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.client.spi.form.FormActions;
import io.dialob.compiler.Utils;
import io.dialob.executor.model.ErrorState;
import io.dialob.executor.model.IdUtils;
import io.dialob.executor.model.ItemId;
import io.dialob.executor.model.ItemState;
import io.dialob.executor.model.SessionObject;
import io.dialob.executor.model.ValueSetState;
import io.dialob.program.EvalContext;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FormActionsUpdatesItemsVisitor
implements EvalContext.UpdatedItemsVisitor {
    private final FormActions formActions;
    private final Predicate<SessionObject> isVisiblePredicate;
    private final Function<ItemState, ActionItem> toActionItemFunction;

    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedSessionStateVisitor> visitSession() {
        return Optional.of((original, updated) -> this.languageChanged(updated));
    }

    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedErrorStateVisitor> visitUpdatedErrorStates() {
        return Optional.of((original, updated) -> {
            boolean originalVisible;
            boolean updatedVisible = updated != null && this.isVisiblePredicate.test((SessionObject)updated);
            boolean bl = originalVisible = original != null && this.isVisiblePredicate.test((SessionObject)original);
            if (originalVisible && !updatedVisible) {
                this.inactivated(original);
                return;
            }
            if (!originalVisible && updatedVisible) {
                this.activated(updated);
                return;
            }
            if (updatedVisible) {
                this.updated(updated);
            }
        });
    }

    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedItemStateVisitor> visitUpdatedItems() {
        return Optional.of((original, updated) -> {
            boolean originalVisible;
            boolean updatedVisible = updated != null && this.isVisiblePredicate.test((SessionObject)updated);
            boolean bl = originalVisible = original != null && this.isVisiblePredicate.test((SessionObject)original);
            if (!originalVisible && !updatedVisible) {
                return;
            }
            if (originalVisible && !updatedVisible) {
                this.inactivated(updated != null ? updated : original);
                return;
            }
            if (!originalVisible) {
                this.activated(updated);
                return;
            }
            if (original.isDisabled() && !updated.isDisabled()) {
                this.enabled(updated);
                return;
            }
            if (!original.isDisabled() && updated.isDisabled()) {
                this.disabled(updated);
                return;
            }
            if (!Objects.equals(original, updated)) {
                this.updated(updated);
            }
        });
    }

    public Optional<EvalContext.UpdatedItemsVisitor.UpdatedValueSetVisitor> visitUpdatedValueSets() {
        return Optional.of((original, updated) -> {
            if (updated != null) {
                this.updated(updated);
            }
        });
    }

    @Nonnull
    public FormActions getFormActions() {
        return this.formActions;
    }

    protected void updated(@Nonnull ErrorState updated) {
        this.formActions.addError(Utils.toError((ErrorState)updated));
    }

    protected void updated(@Nonnull ValueSetState updated) {
        this.formActions.newValueSet(Utils.toValueSet((ValueSetState)updated));
    }

    protected void activated(@Nonnull ErrorState updated) {
        this.formActions.addError(Utils.toError((ErrorState)updated));
    }

    protected void inactivated(@Nonnull ErrorState updated) {
        this.formActions.removeError((Error)ImmutableError.builder().id(IdUtils.toString((ItemId)updated.getItemId())).code(updated.getCode()).build());
    }

    protected void disabled(@Nonnull ItemState updated) {
        this.updated(updated);
    }

    protected void enabled(@Nonnull ItemState updated) {
        this.updated(updated);
    }

    protected void activated(@Nonnull ItemState updated) {
        this.formActions.newQuestion(this.toActionItemFunction.apply(updated));
    }

    protected void inactivated(@Nonnull ItemState updated) {
        this.formActions.removeQuestion(IdUtils.toString((ItemId)updated.getId()));
    }

    protected void updated(@Nonnull ItemState updated) {
        this.formActions.updateQuestion(this.toActionItemFunction.apply(updated));
    }

    protected void languageChanged(@Nonnull String language) {
        this.formActions.locale(new Locale(language));
    }

    public void visitCompleted() {
        this.formActions.complete();
    }

    public FormActionsUpdatesItemsVisitor(FormActions formActions, Predicate<SessionObject> isVisiblePredicate, Function<ItemState, ActionItem> toActionItemFunction) {
        this.formActions = formActions;
        this.isVisiblePredicate = isVisiblePredicate;
        this.toActionItemFunction = toActionItemFunction;
    }
}

