/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.form;

import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.client.spi.form.FormActions;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormActionsUpdatesCallback
implements QuestionnaireSession.UpdatesCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormActionsUpdatesCallback.class);
    private final FormActions formActions;

    public FormActionsUpdatesCallback(@Nonnull FormActions formActions) {
        this.formActions = formActions;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback questionAdded(@Nonnull ActionItem question) {
        LOGGER.debug("newQuestion({})", (Object)question);
        this.formActions.newQuestion(question);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback questionUpdated(@Nonnull ActionItem question) {
        LOGGER.debug("updateQuestion({})", (Object)question);
        this.formActions.updateQuestion(question);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback questionRemoved(@Nonnull String itemId) {
        LOGGER.debug("removeQuestion({})", (Object)itemId);
        this.formActions.removeQuestion(itemId);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback valueSetAdded(@Nonnull ValueSet valueSet) {
        LOGGER.debug("valueSetAdded({})", (Object)valueSet);
        this.formActions.newValueSet(valueSet);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback valueSetUpdated(@Nonnull ValueSet valueSet) {
        LOGGER.debug("valueSetUpdated({})", (Object)valueSet);
        this.formActions.updateValueSet(valueSet);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback valueSetRemoved(@Nonnull String valueSetId) {
        LOGGER.debug("valueSetRemoved({})", (Object)valueSetId);
        this.formActions.removeValueSet(valueSetId);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback errorAdded(@Nonnull Error error) {
        LOGGER.debug("addError({})", (Object)error);
        this.formActions.addError(error);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback errorRemoved(@Nonnull Error error) {
        LOGGER.debug("removeError({})", (Object)error);
        this.formActions.removeError(error);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback removeAll() {
        LOGGER.debug("removeAll()");
        this.formActions.removeAll();
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback locale(Locale locale) {
        LOGGER.debug("locale({})", (Object)locale);
        this.formActions.locale(locale);
        return this;
    }

    @Override
    @Nonnull
    public FormActionsUpdatesCallback completed() {
        LOGGER.debug("completed()");
        this.formActions.complete();
        return this;
    }
}

