/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.form;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class FormActions
implements Serializable {
    private static final long serialVersionUID = -5620097650456059820L;
    private static final ImmutableAction RESET_ACTION = ImmutableAction.builder().type(Action.Type.RESET).build();
    private final List<Action> preActions = new ArrayList<Action>();
    private final List<Action> added = new ArrayList<Action>();
    private final List<Action> updated = new ArrayList<Action>();
    private final List<String> removedQuestions = new ArrayList<String>();
    private final List<String> removedValueSets = new ArrayList<String>();
    private final List<Action> addedErrors = new ArrayList<Action>();
    private final List<Action> removedErrors = new ArrayList<Action>();
    private final List<Action> postActions = new ArrayList<Action>();

    public void clear() {
        this.preActions.clear();
        this.added.clear();
        this.updated.clear();
        this.removedQuestions.clear();
        this.removedValueSets.clear();
        this.addedErrors.clear();
        this.removedErrors.clear();
        this.postActions.clear();
    }

    public void locale(Locale locale) {
        if (locale != null) {
            this.preActions.add((Action)ImmutableAction.builder().type(Action.Type.LOCALE).value((Object)locale.toString()).build());
        }
    }

    public void newQuestion(@Nonnull ActionItem question) {
        this.added.add((Action)ImmutableAction.builder().type(Action.Type.ITEM).item(question).build());
    }

    public void updateQuestion(@Nonnull ActionItem question) {
        this.updated.add((Action)ImmutableAction.builder().type(Action.Type.ITEM).item(question).build());
    }

    public void removeQuestion(@Nonnull String questionId) {
        this.removedQuestions.add(questionId);
    }

    public void newValueSet(@Nonnull ValueSet valueSet) {
        this.added.add((Action)ImmutableAction.builder().type(Action.Type.VALUE_SET).valueSet(valueSet).build());
    }

    public void updateValueSet(@Nonnull ValueSet valueSet) {
        this.updated.add((Action)ImmutableAction.builder().type(Action.Type.VALUE_SET).valueSet(valueSet).build());
    }

    public void removeValueSet(@Nonnull String valueSetId) {
        this.removedValueSets.add(valueSetId);
    }

    public void addError(@Nonnull Error error) {
        this.addedErrors.add((Action)ImmutableAction.builder().type(Action.Type.ERROR).error(error).build());
    }

    public void removeError(@Nonnull Error error) {
        this.removedErrors.add((Action)ImmutableAction.builder().type(Action.Type.REMOVE_ERROR).error(error).build());
    }

    public void removeAll() {
        this.preActions.add((Action)RESET_ACTION);
    }

    public void complete() {
        this.postActions.add((Action)ImmutableAction.builder().type(Action.Type.COMPLETE).build());
    }

    @Nonnull
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(this.preActions);
        actions.addAll(this.removedErrors);
        if (!this.removedQuestions.isEmpty()) {
            actions.add((Action)ImmutableAction.builder().type(Action.Type.REMOVE_ITEMS).ids(this.removedQuestions).build());
        }
        if (!this.removedValueSets.isEmpty()) {
            actions.add((Action)ImmutableAction.builder().type(Action.Type.REMOVE_VALUE_SETS).ids(this.removedValueSets).build());
        }
        actions.addAll(this.added);
        actions.addAll(this.updated);
        actions.addAll(this.addedErrors);
        actions.addAll(this.postActions);
        return actions;
    }
}

