/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.executor.questionnaire;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActionItem;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ImmutableValueSetEntry;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableAnswer;
import io.dialob.api.questionnaire.ImmutableContextValue;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.ImmutableVariableValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.client.api.ImmutableQuestionnaireSession;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.client.spi.event.QuestionnaireEventPublisher;
import io.dialob.client.spi.executor.questionnaire.ConversionUtil;
import io.dialob.client.spi.form.FormActions;
import io.dialob.client.spi.form.FormActionsUpdatesCallback;
import io.dialob.client.spi.form.FormActionsUpdatesItemsVisitor;
import io.dialob.client.spi.function.AsyncFunctionInvoker;
import io.dialob.compiler.Utils;
import io.dialob.executor.DialobSessionUpdater;
import io.dialob.executor.model.DialobSession;
import io.dialob.executor.model.DialobSessionVisitor;
import io.dialob.executor.model.IdUtils;
import io.dialob.executor.model.ItemId;
import io.dialob.executor.model.ItemState;
import io.dialob.executor.model.SessionObject;
import io.dialob.executor.model.ValueSetId;
import io.dialob.executor.model.ValueSetState;
import io.dialob.program.DialobProgram;
import io.dialob.program.DialobSessionEvalContextFactory;
import io.dialob.program.EvalContext;
import io.dialob.program.model.DisplayItem;
import io.dialob.rule.parser.api.ValueType;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class QuestionnaireSessionImpl
implements QuestionnaireSession,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnaireSessionImpl.class);
    private static final long serialVersionUID = -7713834248135795339L;
    private final String rev;
    private final DialobSession dialobSession;
    private final DialobProgram dialobProgram;
    private final QuestionnaireSession.QuestionClientVisibility questionClientVisibility;
    private final AtomicReference<State> state;
    private final Questionnaire.Metadata metadata;
    private final transient QuestionnaireEventPublisher eventPublisher;
    private final transient DialobSessionEvalContextFactory sessionContextFactory;
    private final transient AsyncFunctionInvoker asyncFunctionInvoker;
    private final transient Function<ItemState, ActionItem> toActionItemFunction;

    private QuestionnaireSessionImpl(String rev, @Nonnull DialobSession dialobSession, @Nonnull QuestionnaireSessionImpl dialobQuestionnaireSession) {
        this.rev = rev;
        this.dialobSession = dialobSession;
        this.eventPublisher = dialobQuestionnaireSession.eventPublisher;
        this.sessionContextFactory = dialobQuestionnaireSession.sessionContextFactory;
        this.asyncFunctionInvoker = dialobQuestionnaireSession.asyncFunctionInvoker;
        this.dialobProgram = dialobQuestionnaireSession.dialobProgram;
        this.questionClientVisibility = dialobQuestionnaireSession.questionClientVisibility;
        this.state = new AtomicReference<State>(dialobQuestionnaireSession.state.get());
        this.metadata = dialobQuestionnaireSession.metadata;
        this.toActionItemFunction = dialobQuestionnaireSession.toActionItemFunction;
    }

    private QuestionnaireSessionImpl(@Nonnull QuestionnaireEventPublisher eventPublisher, @Nonnull DialobSessionEvalContextFactory sessionContextFactory, @Nonnull AsyncFunctionInvoker asyncFunctionInvoker, @Nonnull DialobSession dialobSession, @Nonnull DialobProgram dialobProgram, String rev, @Nonnull Questionnaire.Metadata metadata, @Nonnull State state, @Nonnull QuestionnaireSession.QuestionClientVisibility questionClientVisibility) {
        this.rev = rev;
        this.metadata = metadata;
        this.eventPublisher = eventPublisher;
        this.sessionContextFactory = sessionContextFactory;
        this.asyncFunctionInvoker = asyncFunctionInvoker;
        this.dialobSession = dialobSession;
        this.dialobProgram = dialobProgram;
        this.questionClientVisibility = questionClientVisibility;
        this.state = new AtomicReference<State>(state);
        this.toActionItemFunction = itemState -> Utils.toActionItem((ItemState)itemState, builder -> {
            if (itemState.hasCustomProps()) {
                ItemId id = itemState.getPrototypeId();
                if (id == null) {
                    id = itemState.getId();
                }
                dialobProgram.getItem(id).filter(item -> item instanceof DisplayItem).map(item -> ((DisplayItem)item).getProps()).ifPresent(arg_0 -> ((ImmutableActionItem.Builder)builder).props(arg_0));
            }
            return builder;
        });
    }

    @Override
    public QuestionnaireSession withIdAndRev(String id, String rev) {
        return new QuestionnaireSessionImpl(rev, this.dialobSession.withId(id), this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(@Nonnull CodedOutputStream output) throws IOException {
        Utils.writeNullableString((CodedOutputStream)output, (String)this.rev);
        output.writeInt32NoTag(this.questionClientVisibility.ordinal());
        output.writeInt32NoTag(this.state.get().ordinal());
        output.writeStringNoTag(this.metadata.getStatus().name());
        output.writeStringNoTag(this.metadata.getFormId());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getFormRev());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getLanguage());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getLabel());
        Utils.writeNullableDate((CodedOutputStream)output, (Date)this.metadata.getCreated());
        Utils.writeNullableDate((CodedOutputStream)output, (Date)this.metadata.getLastAnswer());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getCreator());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getOwner());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getTenantId());
        Utils.writeNullableString((CodedOutputStream)output, (String)this.metadata.getSubmitUrl());
        output.writeInt32NoTag(this.metadata.getAdditionalProperties().size());
        for (Map.Entry entry : this.metadata.getAdditionalProperties().entrySet()) {
            output.writeStringNoTag((String)entry.getKey());
            Utils.writeObjectValue((CodedOutputStream)output, entry.getValue());
        }
        this.dialobSession.writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public QuestionnaireSession.DispatchActionsResult dispatchActions(String revision, @Nonnull Collection<Action> actions) {
        final QuestionnaireSessionImpl questionnaireSession = this;
        final ImmutableQuestionnaireSession.DispatchActionsResult.Builder result = ImmutableQuestionnaireSession.DispatchActionsResult.builder().isDidComplete(false);
        if (this.isCompleted()) {
            return result.actions((Actions)ImmutableActions.builder().rev(this.dialobSession.getRevision()).build()).build();
        }
        FormActions formActions = new FormActions();
        try {
            MDC.put((String)"questionnaire", (String)this.getSessionId().orElse("no-session-id"));
            boolean revisionMatch = revision != null && revision.equals(this.dialobSession.getRevision());
            LOGGER.debug("revision comparison: {} vs. {} == {}", new Object[]{revision, this.dialobSession.getRevision(), revisionMatch});
            DialobSessionUpdater sessionUpdater = this.sessionContextFactory.createSessionUpdater(this.dialobProgram, this.dialobSession);
            List userActions = actions.stream().filter(action -> action.getType().isClientAction()).collect(Collectors.toList());
            FormActionsUpdatesItemsVisitor actionsUpdatesItemsVisitor = new FormActionsUpdatesItemsVisitor(formActions, this.getIsVisiblePredicate(), this.toActionItemFunction);
            sessionUpdater.dispatchActions(actions, this.state.get() == State.ACTIVATING).accept(new EvalContext.AbstractDelegateUpdatedItemsVisitor(actionsUpdatesItemsVisitor){

                public void visitCompleted() {
                    super.visitCompleted();
                    result.isDidComplete(true);
                    QuestionnaireSessionImpl.this.getSessionId().ifPresent(sessionId -> QuestionnaireSessionImpl.this.eventPublisher.completed((String)sessionId));
                }

                public Optional<EvalContext.UpdatedItemsVisitor.AsyncFunctionCallVisitor> visitAsyncFunctionCalls() {
                    return Optional.of(QuestionnaireSessionImpl.this.asyncFunctionInvoker.createVisitor(questionnaireSession));
                }
            });
            ArrayList updateActions = new ArrayList(userActions);
            ArrayList<Action> broadcastActions = updateActions;
            updateActions.addAll(formActions.getActions());
            if (!revisionMatch) {
                formActions.clear();
                this.buildFullForm(new FormActionsUpdatesCallback(formActions));
                broadcastActions = formActions.getActions();
            }
            if (!updateActions.isEmpty() && this.isActive()) {
                this.publishQuestionnaireActions(this.dialobSession.getRevision(), broadcastActions);
            }
        }
        finally {
            MDC.remove((String)"questionnaire");
        }
        return result.actions((Actions)ImmutableActions.builder().actions(formActions.getActions()).rev(this.dialobSession.getRevision()).build()).build();
    }

    @Override
    @Nonnull
    public QuestionnaireSession.DispatchActionsResult dispatchActions(@Nonnull Collection<Action> actions) {
        return this.dispatchActions(this.dialobSession.getRevision(), actions);
    }

    @Override
    @Nonnull
    public Questionnaire getQuestionnaire() {
        Questionnaire.Metadata.Status status;
        if (this.dialobSession.isCompleted()) {
            status = Questionnaire.Metadata.Status.COMPLETED;
        } else {
            switch (this.state.get()) {
                case ACTIVATING: 
                case NEW: {
                    status = Questionnaire.Metadata.Status.NEW;
                    break;
                }
                default: {
                    status = Questionnaire.Metadata.Status.OPEN;
                }
            }
        }
        return ImmutableQuestionnaire.builder().id(this.dialobSession.getId()).rev(this.rev).context(this.getContextVariableValues()).answers(this.getAnswers()).errors(this.getErrors()).variableValues(this.getVariableValues()).activeItem((String)this.getActiveItem().orElse(null)).valueSets(this.getProvidedValueSets()).metadata((Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().from(this.metadata).lastAnswer(new Date(this.dialobSession.getLastUpdate().toEpochMilli())).completed(this.dialobSession.getCompleted() != null ? new Date(this.dialobSession.getCompleted().toEpochMilli()) : null).opened(this.dialobSession.getOpened() != null ? new Date(this.dialobSession.getOpened().toEpochMilli()) : null).status(status).language(this.dialobSession.getLanguage()).tenantId(this.dialobSession.getTenantId()).build()).build();
    }

    private Iterable<? extends ValueSet> getProvidedValueSets() {
        return () -> this.dialobSession.getValueSetStates().values().stream().map(state -> ImmutableValueSet.builder().id(state.getId().getValueSetId()).entries(() -> state.getEntries().stream().filter(ValueSetState.Entry::isProvided).map(entry -> ImmutableValueSetEntry.builder().key(entry.getId()).value(entry.getLabel()).build()).iterator()).build()).iterator();
    }

    private Iterable<? extends ContextValue> getContextVariableValues() {
        final ArrayList answers = new ArrayList();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (Utils.isContextVariable((String)itemState.getType())) {
                        Object value = ConversionUtil.toJSON(itemState.getValue());
                        answers.add(ImmutableContextValue.builder().id(IdUtils.toString((ItemId)itemState.getId())).value((Object)(value == null ? null : value.toString())).build());
                    }
                });
            }
        });
        return answers;
    }

    @Override
    @Nonnull
    public String getRevision() {
        return this.dialobSession.getRevision();
    }

    @Override
    public String getRev() {
        return this.rev;
    }

    @Override
    @Nullable
    public String getOwner() {
        return this.metadata.getOwner();
    }

    @Override
    @Nonnull
    public Instant getLastUpdate() {
        return this.dialobSession.getLastUpdate();
    }

    @Override
    public Optional<String> getActiveItem() {
        return this.dialobSession.getRootItem().getActivePage().map(IdUtils::toString);
    }

    @Override
    @Nonnull
    public List<ValueSet> getValueSets() {
        final ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ValueSetVisitor> visitValueSetStates() {
                return Optional.of(valueSetState -> valueSets.add(ImmutableValueSet.builder().id(IdUtils.toString((ValueSetId)valueSetState.getId())).entries((Iterable)valueSetState.getEntries().stream().map(entry -> ImmutableValueSetEntry.builder().key(entry.getId()).value(entry.getLabel()).build()).collect(Collectors.toList())).build()));
            }
        });
        return valueSets;
    }

    @Override
    @Nonnull
    public List<Error> getErrors() {
        final ArrayList<Error> errors = new ArrayList<Error>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ErrorVisitor> visitErrorStates() {
                return Optional.of(errorState -> {
                    if (errorState.isActive()) {
                        errors.add(ImmutableError.builder().code(errorState.getCode()).id(IdUtils.toString((ItemId)errorState.getItemId())).description(errorState.getLabel()).build());
                    }
                });
            }
        });
        return errors;
    }

    @Override
    @Nonnull
    public List<ActionItem> getItems() {
        final ArrayList<ActionItem> formItems = new ArrayList<ActionItem>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> formItems.add(QuestionnaireSessionImpl.this.toActionItemFunction.apply(itemState)));
            }
        });
        return formItems;
    }

    @Override
    public Optional<ActionItem> getItemById(@Nonnull String itemId) {
        return this.dialobSession.getItemState(IdUtils.toId((String)itemId)).map(this.toActionItemFunction);
    }

    @Override
    @Nonnull
    public List<ActionItem> getVisibleItems() {
        final ArrayList<ActionItem> formItems = new ArrayList<ActionItem>();
        final Predicate<SessionObject> isVisiblePredicate = this.getIsVisiblePredicate();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (isVisiblePredicate.test(itemState)) {
                        formItems.add(QuestionnaireSessionImpl.this.toActionItemFunction.apply(itemState));
                    }
                });
            }
        });
        return formItems;
    }

    @Override
    @Nonnull
    public List<Answer> getAnswers() {
        final ArrayList<Answer> answers = new ArrayList<Answer>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (itemState.isActive() && Utils.isQuestionType((ItemState)itemState)) {
                        ImmutableAnswer.Builder answerBuilder = ImmutableAnswer.builder().id(IdUtils.toString((ItemId)itemState.getId())).value(itemState.getAnswer());
                        ItemId itemId = itemState.getPrototypeId();
                        if (itemId == null) {
                            itemId = itemState.getId();
                        }
                        QuestionnaireSessionImpl.this.dialobProgram.getItem(itemId).ifPresent(item -> {
                            ValueType valueType = item.getValueType();
                            if (valueType != null) {
                                answerBuilder.type(valueType.getName());
                            }
                        });
                        answers.add(answerBuilder.build());
                    }
                });
            }
        });
        return answers;
    }

    @Override
    @Nonnull
    public List<VariableValue> getVariableValues() {
        final ArrayList<VariableValue> answers = new ArrayList<VariableValue>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (Utils.isProgramVariable((String)itemState.getType())) {
                        Object value = ConversionUtil.toJSON(itemState.getValue());
                        answers.add(ImmutableVariableValue.builder().id(IdUtils.toString((ItemId)itemState.getId())).value((Object)(value == null ? null : value.toString())).build());
                    }
                });
            }
        });
        return answers;
    }

    @Override
    public void buildFullForm(@Nonnull QuestionnaireSession.UpdatesCallback updatesCallback) {
        updatesCallback.removeAll();
        this.getLocale().ifPresent(updatesCallback::locale);
        this.getVisibleItems().forEach(updatesCallback::questionAdded);
        this.getValueSets().forEach(updatesCallback::valueSetAdded);
        this.getErrors().forEach(updatesCallback::errorAdded);
        if (this.dialobSession.isCompleted()) {
            updatesCallback.completed();
        }
    }

    @Override
    public Optional<String> getSessionId() {
        return Optional.ofNullable(this.dialobSession.getId());
    }

    @Override
    public String getTenantId() {
        return this.dialobSession.getTenantId();
    }

    public void initialize() {
        this.getSessionId().ifPresent(this.eventPublisher::created);
    }

    @Override
    public void activate() {
        if (!this.state.compareAndSet(State.PASSIVE, State.ACTIVATING) && !this.state.compareAndSet(State.NEW, State.ACTIVATING)) {
            return;
        }
        ArrayList<Action> restoreActions = new ArrayList<Action>();
        if (this.metadata.getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            restoreActions.add(ActionsFactory.complete((String)this.dialobSession.getId()));
        }
        this.dispatchActions(restoreActions);
        this.state.set(State.ACTIVE);
        this.getSessionId().ifPresent(this.eventPublisher::opened);
    }

    @Nonnull
    static String[] convertRows(List<String> rows) {
        Pattern pattern = Pattern.compile("^([^\\[]+)\\[(\\d+)]$");
        return (String[])rows.stream().map(pattern::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1) + "." + matcher.group(2)).toArray(String[]::new);
    }

    @Override
    public void passivate() {
        if (!this.state.compareAndSet(State.ACTIVE, State.PASSIVATING)) {
            return;
        }
        this.state.compareAndSet(State.PASSIVATING, State.PASSIVE);
    }

    @Override
    public boolean isActive() {
        return this.state.get() == State.ACTIVE;
    }

    @Override
    public boolean isCompleted() {
        return this.getStatus() == Questionnaire.Metadata.Status.COMPLETED;
    }

    @Override
    public boolean usesLastestFormRevision() {
        return true;
    }

    @Override
    @Nonnull
    public String getFormId() {
        return this.dialobProgram.getProgram().getId();
    }

    @Override
    public Optional<Locale> getLocale() {
        String language = this.dialobSession.getLanguage();
        if (StringUtils.isNotBlank((CharSequence)language)) {
            return Optional.of(new Locale(language));
        }
        return Optional.empty();
    }

    @Override
    public QuestionnaireSession.QuestionClientVisibility getQuestionClientVisibility() {
        return this.questionClientVisibility;
    }

    @Override
    public void close() {
    }

    Predicate<SessionObject> getIsVisiblePredicate() {
        switch (this.questionClientVisibility) {
            case ALL: {
                return itemState -> itemState != null && itemState.isDisplayItem();
            }
            case SHOW_DISABLED: {
                return itemState -> itemState != null && itemState.isDisplayItem() && itemState.isActive();
            }
        }
        return itemState -> itemState != null && itemState.isDisplayItem() && itemState.isActive() && !itemState.isDisabled();
    }

    private void publishQuestionnaireActions(String nextRevision, List<Action> actionQueue) {
        if (!actionQueue.isEmpty() && this.eventPublisher != null) {
            ImmutableActions.Builder builder = ImmutableActions.builder().rev(nextRevision);
            actionQueue.stream().map(action -> ImmutableAction.builder().from(action).serverEvent(Boolean.valueOf(true)).build()).forEach(arg_0 -> ((ImmutableActions.Builder)builder).addActions(arg_0));
            this.getSessionId().ifPresent(sessionId -> this.eventPublisher.actions((String)sessionId, (Actions)builder.build()));
        }
    }

    @Override
    @Nonnull
    public Questionnaire.Metadata.Status getStatus() {
        return this.dialobSession.isCompleted() ? Questionnaire.Metadata.Status.COMPLETED : Questionnaire.Metadata.Status.OPEN;
    }

    @Nonnull
    public DialobProgram getDialobProgram() {
        return this.dialobProgram;
    }

    @Nonnull
    public DialobSession getDialobSession() {
        return this.dialobSession;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionnaireSessionImpl)) {
            return false;
        }
        QuestionnaireSessionImpl other = (QuestionnaireSessionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rev = this.getRev();
        String other$rev = other.getRev();
        if (this$rev == null ? other$rev != null : !this$rev.equals(other$rev)) {
            return false;
        }
        DialobSession this$dialobSession = this.getDialobSession();
        DialobSession other$dialobSession = other.getDialobSession();
        if (this$dialobSession == null ? other$dialobSession != null : !this$dialobSession.equals(other$dialobSession)) {
            return false;
        }
        DialobProgram this$dialobProgram = this.getDialobProgram();
        DialobProgram other$dialobProgram = other.getDialobProgram();
        if (this$dialobProgram == null ? other$dialobProgram != null : !this$dialobProgram.equals(other$dialobProgram)) {
            return false;
        }
        QuestionnaireSession.QuestionClientVisibility this$questionClientVisibility = this.getQuestionClientVisibility();
        QuestionnaireSession.QuestionClientVisibility other$questionClientVisibility = other.getQuestionClientVisibility();
        if (this$questionClientVisibility == null ? other$questionClientVisibility != null : !((Object)((Object)this$questionClientVisibility)).equals((Object)other$questionClientVisibility)) {
            return false;
        }
        Questionnaire.Metadata this$metadata = this.metadata;
        Questionnaire.Metadata other$metadata = other.metadata;
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestionnaireSessionImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rev = this.getRev();
        result = result * 59 + ($rev == null ? 43 : $rev.hashCode());
        DialobSession $dialobSession = this.getDialobSession();
        result = result * 59 + ($dialobSession == null ? 43 : $dialobSession.hashCode());
        DialobProgram $dialobProgram = this.getDialobProgram();
        result = result * 59 + ($dialobProgram == null ? 43 : $dialobProgram.hashCode());
        QuestionnaireSession.QuestionClientVisibility $questionClientVisibility = this.getQuestionClientVisibility();
        result = result * 59 + ($questionClientVisibility == null ? 43 : ((Object)((Object)$questionClientVisibility)).hashCode());
        Questionnaire.Metadata $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "QuestionnaireSessionImpl(rev=" + this.getRev() + ", dialobSession=" + this.getDialobSession() + ", dialobProgram=" + this.getDialobProgram() + ", questionClientVisibility=" + this.getQuestionClientVisibility() + ", state=" + this.state + ", metadata=" + this.metadata + ", eventPublisher=" + this.eventPublisher + ", sessionContextFactory=" + this.sessionContextFactory + ", asyncFunctionInvoker=" + this.asyncFunctionInvoker + ", toActionItemFunction=" + this.toActionItemFunction + ")";
    }

    public static class Builder {
        private QuestionnaireEventPublisher eventPublisher;
        private DialobSessionEvalContextFactory sessionContextFactory;
        private AsyncFunctionInvoker asyncFunctionInvoker;
        private String rev;
        private DialobSession dialobSession;
        private DialobProgram dialobProgram;
        private State state = State.NEW;
        private QuestionnaireSession.QuestionClientVisibility questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.ONLY_ENABLED;
        private Questionnaire.Metadata metadata;

        public Builder readFrom(@Nonnull CodedInputStream input) throws IOException {
            this.rev = Utils.readNullableString((CodedInputStream)input);
            this.questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.values()[input.readInt32()];
            this.state = State.values()[input.readInt32()];
            ImmutableQuestionnaireMetadata.Builder metadataBuilder = ImmutableQuestionnaireMetadata.builder().status(Questionnaire.Metadata.Status.valueOf((String)input.readString())).formId(input.readString()).formRev(Utils.readNullableString((CodedInputStream)input)).language(Utils.readNullableString((CodedInputStream)input)).label(Utils.readNullableString((CodedInputStream)input)).created(Utils.readNullableDate((CodedInputStream)input)).lastAnswer(Utils.readNullableDate((CodedInputStream)input)).creator(Utils.readNullableString((CodedInputStream)input)).owner(Utils.readNullableString((CodedInputStream)input)).tenantId(Utils.readNullableString((CodedInputStream)input)).submitUrl(Utils.readNullableString((CodedInputStream)input));
            int additionalPropertiesCount = input.readInt32();
            for (int i = 0; i < additionalPropertiesCount; ++i) {
                String key = input.readString();
                Object value = Utils.readObjectValue((CodedInputStream)input);
                metadataBuilder.putAdditionalProperties(key, value);
            }
            this.metadata = metadataBuilder.build();
            this.dialobSession = DialobSession.readFrom((CodedInputStream)input);
            return this;
        }

        public Builder eventPublisher(QuestionnaireEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            return this;
        }

        public Builder sessionContextFactory(DialobSessionEvalContextFactory sessionContextFactory) {
            this.sessionContextFactory = sessionContextFactory;
            return this;
        }

        public Builder asyncFunctionInvoker(AsyncFunctionInvoker asyncFunctionInvoker) {
            this.asyncFunctionInvoker = asyncFunctionInvoker;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder dialobSession(DialobSession dialobSession) {
            this.dialobSession = dialobSession;
            return this;
        }

        public Builder dialobProgram(DialobProgram dialobProgram) {
            this.dialobProgram = dialobProgram;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder questionClientVisibility(@Nonnull QuestionnaireSession.QuestionClientVisibility questionClientVisibility) {
            this.questionClientVisibility = questionClientVisibility;
            return this;
        }

        public Builder metadata(Questionnaire.Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Questionnaire.Metadata getMetadata() {
            return this.metadata;
        }

        public QuestionnaireSessionImpl build() {
            return new QuestionnaireSessionImpl(Objects.requireNonNull(this.eventPublisher, "eventPublisher is null"), Objects.requireNonNull(this.sessionContextFactory, "sessionContextFactory is null"), Objects.requireNonNull(this.asyncFunctionInvoker, "asyncFunctionInvoker is null"), this.dialobSession, this.dialobProgram, this.rev, this.metadata, this.state, this.questionClientVisibility);
        }
    }

    static enum State {
        NEW,
        ACTIVATING,
        ACTIVE,
        PASSIVATING,
        PASSIVE;

    }
}

