/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.executor;

import io.dialob.api.form.Form;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.ImmutableExecutorBody;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.client.spi.executor.questionnaire.QuestionnaireSessionImpl;
import io.dialob.client.spi.form.FormActions;
import io.dialob.client.spi.form.FormActionsUpdatesCallback;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.executor.model.DialobSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireExecutorImpl
implements DialobClient.QuestionnaireExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnaireExecutorImpl.class);
    private final Questionnaire questionnaire;
    private final DialobClient.ProgramWrapper formAndProgram;
    private final DialobSession dialobSession;
    private final DialobClientConfig config;
    private final boolean newSession;
    private boolean createOnly;
    private QuestionnaireSessionImpl questionnaireSessionImpl;
    private Actions actions;

    @Override
    public DialobClient.QuestionnaireExecutor actions(Actions actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public DialobClient.QuestionnaireExecutor createOnly(boolean createOnly) {
        this.createOnly = createOnly;
        return this;
    }

    @Override
    public Actions execute() {
        return this.executeAndGetBody().getActions();
    }

    protected QuestionnaireSessionImpl createQuestionnaireSession() {
        if (this.questionnaireSessionImpl != null) {
            return this.questionnaireSessionImpl;
        }
        QuestionnaireSessionImpl state = null;
        try {
            state = QuestionnaireSessionImpl.builder().eventPublisher(this.config.getEventPublisher()).sessionContextFactory(this.config.getFactory()).asyncFunctionInvoker(this.config.getAsyncFunctionInvoker()).dialobSession(this.dialobSession).dialobProgram(this.formAndProgram.getProgram().get()).rev(this.questionnaire.getRev()).metadata(this.questionnaire.getMetadata()).questionClientVisibility(this.getQuestionClientVisibility(((DialobDocument.FormDocument)this.formAndProgram.getDocument()).getData())).build();
            if (this.newSession && !this.createOnly) {
                state.initialize();
            }
            state.activate();
            this.questionnaireSessionImpl = state;
            return state;
        }
        catch (Exception e) {
            if (state != null) {
                state.close();
            }
            throw e;
        }
    }

    protected QuestionnaireSession.QuestionClientVisibility getQuestionClientVisibility(Form formDocument) {
        QuestionnaireSession.QuestionClientVisibility questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.ONLY_ENABLED;
        Object o = formDocument.getMetadata().getAdditionalProperties().get("questionClientVisibility");
        if (o instanceof String) {
            try {
                return QuestionnaireSession.QuestionClientVisibility.valueOf((String)o);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unknown question client visibility {}", o);
            }
        }
        if ((o = formDocument.getMetadata().getAdditionalProperties().get("showDisabled")) != null) {
            boolean showDisabled = false;
            if (o instanceof String) {
                showDisabled = Boolean.parseBoolean((String)o);
            } else if (o instanceof Boolean) {
                showDisabled = (Boolean)o;
            }
            if (showDisabled) {
                questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.SHOW_DISABLED;
            }
        }
        return questionClientVisibility;
    }

    @Override
    public QuestionnaireSession toSession() {
        DialobAssert.notEmpty(this.questionnaire.getId(), () -> "questionnaire.id must be defined!");
        DialobAssert.notEmpty(this.questionnaire.getRev(), () -> "questionnaire.rev must be defined!");
        if (this.questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            this.dialobSession.complete();
        }
        return this.createQuestionnaireSession();
    }

    @Override
    public DialobClient.ExecutorBody executeAndGetBody() {
        QuestionnaireSessionImpl state;
        DialobAssert.notEmpty(this.questionnaire.getId(), () -> "questionnaire.id must be defined!");
        DialobAssert.notEmpty(this.questionnaire.getRev(), () -> "questionnaire.rev must be defined!");
        if (this.questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            this.dialobSession.complete();
        }
        if ((state = this.createQuestionnaireSession()).isCompleted()) {
            return ImmutableExecutorBody.builder().questionnaire(state.getQuestionnaire()).actions((Actions)ImmutableActions.builder().rev(state.getRev()).build()).build();
        }
        if (this.actions == null || this.actions.getActions().isEmpty()) {
            FormActions formActions = new FormActions();
            state.buildFullForm(new FormActionsUpdatesCallback(formActions));
            return ImmutableExecutorBody.builder().questionnaire(state.getQuestionnaire()).actions((Actions)ImmutableActions.builder().actions(formActions.getActions()).rev(state.getRevision()).build()).build();
        }
        String rev = this.actions.getRev() == null ? state.getRev() : this.actions.getRev();
        QuestionnaireSession.DispatchActionsResult response = state.dispatchActions(rev, this.actions.getActions());
        if (response.isDidComplete()) {
            state.getSessionId().ifPresent(sessionId -> this.config.getEventPublisher().completed((String)sessionId));
        }
        return ImmutableExecutorBody.builder().questionnaire(state.getQuestionnaire()).actions(response.getActions()).build();
    }

    public QuestionnaireExecutorImpl(Questionnaire questionnaire, DialobClient.ProgramWrapper formAndProgram, DialobSession dialobSession, DialobClientConfig config, boolean newSession) {
        this.questionnaire = questionnaire;
        this.formAndProgram = formAndProgram;
        this.dialobSession = dialobSession;
        this.config = config;
        this.newSession = newSession;
    }
}

