/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.executor;

import io.dialob.api.form.Form;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.spi.executor.QuestionnaireExecutorImpl;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.compiler.Utils;
import io.dialob.executor.CreateDialobSessionProgramVisitor;
import io.dialob.executor.model.DialobSession;
import io.dialob.executor.model.IdUtils;
import io.dialob.executor.model.ItemId;
import io.dialob.executor.model.ValueSetState;
import io.dialob.program.DialobProgram;
import io.dialob.program.model.VariableItem;
import io.dialob.rule.parser.api.ValueType;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class QuestionnaireExecutorBuilderImpl
implements DialobClient.QuestionnaireExecutorBuilder {
    private final DialobClient.ProgramEnvir envir;
    private final DialobClientConfig config;

    @Override
    public DialobClient.QuestionnaireExecutor create(String id, Consumer<DialobClient.QuestionnaireInit> initWith) {
        return this.create(id, null, initWith);
    }

    @Override
    public DialobClient.QuestionnaireExecutor create(String id, String rev, Consumer<DialobClient.QuestionnaireInit> initWith) {
        DialobAssert.notNull(id, () -> "id can't be null!");
        DialobAssert.notNull(initWith, () -> "initWith can't be null!");
        DialobClient.ProgramWrapper formAndProgram = rev == null ? this.envir.findByFormId(id) : this.envir.findByFormIdAndRev(id, rev);
        DialobDocument.FormDocument formDocument = (DialobDocument.FormDocument)formAndProgram.getDocument();
        QuestionnaireInitImpl init = new QuestionnaireInitImpl();
        initWith.accept(init);
        DialobAssert.notEmpty(init.id(), () -> "questionnaire.id must be defined!");
        DialobAssert.notEmpty(init.rev(), () -> "questionnaire.rev must be defined!");
        Questionnaire questionnaire = this.createNewQuestionnaire(formDocument.getData(), init);
        DialobSession dialobSession = this.createSession(questionnaire, formAndProgram);
        return new QuestionnaireExecutorImpl(questionnaire, formAndProgram, dialobSession, this.config, true);
    }

    @Override
    public DialobClient.QuestionnaireExecutor restore(Questionnaire questionnaire) {
        DialobAssert.notNull(questionnaire, () -> "questionnaire can't be null!");
        DialobAssert.notEmpty(questionnaire.getId(), () -> "questionnaire.id must be defined!");
        DialobAssert.notEmpty(questionnaire.getRev(), () -> "questionnaire.rev must be defined!");
        DialobClient.ProgramWrapper formAndProgram = this.envir.findByFormIdAndRev(questionnaire.getMetadata().getFormId(), questionnaire.getMetadata().getFormRev());
        DialobSession dialobSession = this.createSession(questionnaire, formAndProgram);
        return new QuestionnaireExecutorImpl(questionnaire, formAndProgram, dialobSession, this.config, false);
    }

    protected DialobSession createSession(Questionnaire questionnaire, DialobClient.ProgramWrapper formAndProgram) {
        DialobProgram dialobProgram = formAndProgram.getProgram().get();
        return dialobProgram.createSession(this.config.getFactory(), ((DialobDocument.FormDocument)formAndProgram.getDocument()).getData().getMetadata().getTenantId(), questionnaire.getId(), questionnaire.getMetadata().getLanguage(), questionnaire.getActiveItem(), this.initialValues(questionnaire), this.findProvidedValueSetEntries(questionnaire), questionnaire.getMetadata().getCompleted(), questionnaire.getMetadata().getOpened(), questionnaire.getMetadata().getLastAnswer());
    }

    protected Questionnaire createNewQuestionnaire(Form formDocument, QuestionnaireInitImpl init) {
        String formId = formDocument.getId();
        ImmutableQuestionnaire.Builder questionnaire = ImmutableQuestionnaire.builder();
        ImmutableQuestionnaireMetadata.Builder metadata = ImmutableQuestionnaireMetadata.builder();
        if (init.additionalProperties() != null) {
            metadata.putAllAdditionalProperties(init.additionalProperties());
        }
        metadata.formId(formId);
        metadata.formName(formDocument.getName());
        metadata.label(formDocument.getMetadata().getLabel());
        metadata.creator(init.creator());
        metadata.owner(StringUtils.defaultString((String)init.owner(), (String)init.creator()));
        metadata.status(init.status() != null ? init.status() : Questionnaire.Metadata.Status.NEW);
        boolean useLatest = "LATEST".equals(formDocument.getRev());
        if (useLatest) {
            metadata.formRev("LATEST");
        } else {
            metadata.formRev(formDocument.getRev());
        }
        metadata.created(new Date());
        if (init.submitUrl() != null) {
            metadata.submitUrl(init.submitUrl());
        }
        metadata.language(init.language());
        questionnaire.metadata((Questionnaire.Metadata)metadata.build());
        if (init.contextValues() != null) {
            questionnaire.context(init.contextValues());
        }
        if (init.answers() != null) {
            questionnaire.answers(init.answers());
        }
        if (init.valueSets() != null) {
            questionnaire.valueSets(init.valueSets());
        }
        return questionnaire.activeItem(init.activeItem).id(init.id()).rev(init.rev()).build();
    }

    protected CreateDialobSessionProgramVisitor.InitialValueResolver initialValues(Questionnaire questionnaire) {
        return (itemId, item) -> {
            String id = IdUtils.toString((ItemId)itemId);
            if (item instanceof VariableItem) {
                for (ContextValue contextValue : questionnaire.getContext()) {
                    if (!id.equals(contextValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse((ValueType)item.getValueType(), (Object)contextValue.getValue()));
                }
                for (VariableValue variableValue : questionnaire.getVariableValues()) {
                    if (!id.equals(variableValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse((ValueType)item.getValueType(), (Object)variableValue.getValue()));
                }
            } else {
                for (Answer answer : questionnaire.getAnswers()) {
                    if (!id.equals(answer.getId())) continue;
                    return Optional.ofNullable(answer.getValue());
                }
            }
            return Optional.empty();
        };
    }

    protected CreateDialobSessionProgramVisitor.ProvidedValueSetEntriesResolver findProvidedValueSetEntries(Questionnaire questionnaire) {
        return valueSetId -> questionnaire.getValueSets().stream().filter(valueSet -> valueSet.getId().equals(valueSetId.getValueSetId())).findFirst().map(valueSet -> valueSet.getEntries().stream().map(entry -> ValueSetState.Entry.of((String)entry.getKey(), (String)entry.getValue(), (boolean)true)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public QuestionnaireExecutorBuilderImpl(DialobClient.ProgramEnvir envir, DialobClientConfig config) {
        this.envir = envir;
        this.config = config;
    }

    public static class QuestionnaireInitImpl
    implements DialobClient.QuestionnaireInit {
        private Questionnaire questionnaire;
        private String activeItem;
        private String id;
        private String rev;
        private String creator;
        private String owner;
        private String submitUrl;
        private List<ContextValue> contextValues;
        private String language = "en";
        private List<Answer> answers;
        private List<ValueSet> valueSets;
        private Questionnaire.Metadata.Status status;
        private Map<String, Object> additionalProperties;

        @Override
        public DialobClient.QuestionnaireInit language(String language) {
            this.language = language;
            if (StringUtils.isBlank((CharSequence)language)) {
                this.language = "en";
            }
            return this;
        }

        public String language() {
            this.language(this.language);
            return this.language;
        }

        public Questionnaire questionnaire() {
            return this.questionnaire;
        }

        public String activeItem() {
            return this.activeItem;
        }

        public String id() {
            return this.id;
        }

        public String rev() {
            return this.rev;
        }

        public String creator() {
            return this.creator;
        }

        public String owner() {
            return this.owner;
        }

        public String submitUrl() {
            return this.submitUrl;
        }

        public List<ContextValue> contextValues() {
            return this.contextValues;
        }

        public List<Answer> answers() {
            return this.answers;
        }

        public List<ValueSet> valueSets() {
            return this.valueSets;
        }

        public Questionnaire.Metadata.Status status() {
            return this.status;
        }

        public Map<String, Object> additionalProperties() {
            return this.additionalProperties;
        }

        @Override
        public QuestionnaireInitImpl questionnaire(Questionnaire questionnaire) {
            this.questionnaire = questionnaire;
            return this;
        }

        @Override
        public QuestionnaireInitImpl activeItem(String activeItem) {
            this.activeItem = activeItem;
            return this;
        }

        @Override
        public QuestionnaireInitImpl id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public QuestionnaireInitImpl rev(String rev) {
            this.rev = rev;
            return this;
        }

        @Override
        public QuestionnaireInitImpl creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public QuestionnaireInitImpl owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public QuestionnaireInitImpl submitUrl(String submitUrl) {
            this.submitUrl = submitUrl;
            return this;
        }

        @Override
        public QuestionnaireInitImpl contextValues(List<ContextValue> contextValues) {
            this.contextValues = contextValues;
            return this;
        }

        @Override
        public QuestionnaireInitImpl answers(List<Answer> answers) {
            this.answers = answers;
            return this;
        }

        @Override
        public QuestionnaireInitImpl valueSets(List<ValueSet> valueSets) {
            this.valueSets = valueSets;
            return this;
        }

        @Override
        public QuestionnaireInitImpl status(Questionnaire.Metadata.Status status) {
            this.status = status;
            return this;
        }

        @Override
        public QuestionnaireInitImpl additionalProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuestionnaireInitImpl)) {
                return false;
            }
            QuestionnaireInitImpl other = (QuestionnaireInitImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Questionnaire this$questionnaire = this.questionnaire();
            Questionnaire other$questionnaire = other.questionnaire();
            if (this$questionnaire == null ? other$questionnaire != null : !this$questionnaire.equals(other$questionnaire)) {
                return false;
            }
            String this$activeItem = this.activeItem();
            String other$activeItem = other.activeItem();
            if (this$activeItem == null ? other$activeItem != null : !this$activeItem.equals(other$activeItem)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$rev = this.rev();
            String other$rev = other.rev();
            if (this$rev == null ? other$rev != null : !this$rev.equals(other$rev)) {
                return false;
            }
            String this$creator = this.creator();
            String other$creator = other.creator();
            if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
                return false;
            }
            String this$owner = this.owner();
            String other$owner = other.owner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            String this$submitUrl = this.submitUrl();
            String other$submitUrl = other.submitUrl();
            if (this$submitUrl == null ? other$submitUrl != null : !this$submitUrl.equals(other$submitUrl)) {
                return false;
            }
            List<ContextValue> this$contextValues = this.contextValues();
            List<ContextValue> other$contextValues = other.contextValues();
            if (this$contextValues == null ? other$contextValues != null : !((Object)this$contextValues).equals(other$contextValues)) {
                return false;
            }
            String this$language = this.language();
            String other$language = other.language();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            List<Answer> this$answers = this.answers();
            List<Answer> other$answers = other.answers();
            if (this$answers == null ? other$answers != null : !((Object)this$answers).equals(other$answers)) {
                return false;
            }
            List<ValueSet> this$valueSets = this.valueSets();
            List<ValueSet> other$valueSets = other.valueSets();
            if (this$valueSets == null ? other$valueSets != null : !((Object)this$valueSets).equals(other$valueSets)) {
                return false;
            }
            Questionnaire.Metadata.Status this$status = this.status();
            Questionnaire.Metadata.Status other$status = other.status();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            Map<String, Object> this$additionalProperties = this.additionalProperties();
            Map<String, Object> other$additionalProperties = other.additionalProperties();
            return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QuestionnaireInitImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Questionnaire $questionnaire = this.questionnaire();
            result = result * 59 + ($questionnaire == null ? 43 : $questionnaire.hashCode());
            String $activeItem = this.activeItem();
            result = result * 59 + ($activeItem == null ? 43 : $activeItem.hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $rev = this.rev();
            result = result * 59 + ($rev == null ? 43 : $rev.hashCode());
            String $creator = this.creator();
            result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
            String $owner = this.owner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            String $submitUrl = this.submitUrl();
            result = result * 59 + ($submitUrl == null ? 43 : $submitUrl.hashCode());
            List<ContextValue> $contextValues = this.contextValues();
            result = result * 59 + ($contextValues == null ? 43 : ((Object)$contextValues).hashCode());
            String $language = this.language();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            List<Answer> $answers = this.answers();
            result = result * 59 + ($answers == null ? 43 : ((Object)$answers).hashCode());
            List<ValueSet> $valueSets = this.valueSets();
            result = result * 59 + ($valueSets == null ? 43 : ((Object)$valueSets).hashCode());
            Questionnaire.Metadata.Status $status = this.status();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            Map<String, Object> $additionalProperties = this.additionalProperties();
            result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
            return result;
        }

        public String toString() {
            return "QuestionnaireExecutorBuilderImpl.QuestionnaireInitImpl(questionnaire=" + this.questionnaire() + ", activeItem=" + this.activeItem() + ", id=" + this.id() + ", rev=" + this.rev() + ", creator=" + this.creator() + ", owner=" + this.owner() + ", submitUrl=" + this.submitUrl() + ", contextValues=" + this.contextValues() + ", language=" + this.language() + ", answers=" + this.answers() + ", valueSets=" + this.valueSets() + ", status=" + this.status() + ", additionalProperties=" + this.additionalProperties() + ")";
        }
    }
}

