/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.exceptions;

import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StoreException
extends RuntimeException {
    private static final long serialVersionUID = 7058468238867536222L;
    private final String code;
    private final Optional<DialobStore.StoreEntity> target;
    private final List<DialobStore.StoreExceptionMsg> messages = new ArrayList<DialobStore.StoreExceptionMsg>();

    public StoreException(Exception e, String code, DialobStore.StoreEntity target) {
        super(e.getMessage(), e);
        this.code = code;
        this.target = Optional.ofNullable(target);
    }

    public StoreException(Exception e, String code, DialobStore.StoreEntity target, DialobStore.StoreExceptionMsg ... msg) {
        super(e.getMessage(), e);
        this.code = code;
        this.target = Optional.ofNullable(target);
        this.messages.addAll(Arrays.asList(msg));
    }

    public StoreException(String code, DialobStore.StoreEntity target) {
        this.code = code;
        this.target = Optional.ofNullable(target);
    }

    public StoreException(String code, DialobStore.StoreEntity target, DialobStore.StoreExceptionMsg ... msg) {
        super(StoreException.formatMessages(code, target, msg));
        this.code = code;
        this.target = Optional.ofNullable(target);
        this.messages.addAll(Arrays.asList(msg));
    }

    private static String formatMessages(String code, DialobStore.StoreEntity target, DialobStore.StoreExceptionMsg ... msg) {
        StringBuilder builder = new StringBuilder().append(System.lineSeparator()).append("Store operation failed with:").append(System.lineSeparator()).append("  - code: ").append("'" + code + "'").append(System.lineSeparator());
        if (target != null) {
            builder.append("  - entity id: ").append("'" + target.getId() + "'").append(System.lineSeparator());
        }
        for (DialobStore.StoreExceptionMsg m : msg) {
            builder.append("  - msg id: '").append(m.getId()).append("'").append(System.lineSeparator()).append("  - msg value: '").append(m.getValue()).append("'").append(System.lineSeparator()).append("  - msg additional info: ").append(System.lineSeparator());
            for (String arg : m.getArgs()) {
                List nested = Arrays.asList(arg.trim().split(System.lineSeparator())).stream().map(n -> n.trim()).filter(n -> !n.isEmpty()).map(n -> {
                    if (n.startsWith("-")) {
                        return n.substring(1).trim();
                    }
                    return n;
                }).collect(Collectors.toList());
                if (!nested.isEmpty()) {
                    builder.append("    - ").append((String)nested.get(0)).append(System.lineSeparator());
                }
                for (int index = 1; index < nested.size(); ++index) {
                    builder.append("      - ").append((String)nested.get(index)).append(System.lineSeparator());
                }
            }
        }
        return builder.toString();
    }

    public String getCode() {
        return this.code;
    }

    public Optional<DialobStore.StoreEntity> getTarget() {
        return this.target;
    }

    public List<DialobStore.StoreExceptionMsg> getMessages() {
        return this.messages;
    }
}

