/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import io.dialob.api.proto.Actions;
import io.dialob.client.spi.event.EventPublisher;
import io.dialob.client.spi.event.ImmutableQuestionnaireActionsEvent;
import io.dialob.client.spi.event.ImmutableQuestionnaireClientConnectedEvent;
import io.dialob.client.spi.event.ImmutableQuestionnaireClientDisconnectedEvent;
import io.dialob.client.spi.event.ImmutableQuestionnaireCompletedEvent;
import io.dialob.client.spi.event.ImmutableQuestionnaireCreatedEvent;
import io.dialob.client.spi.event.ImmutableQuestionnaireOpenedEvent;
import java.net.InetAddress;
import javax.annotation.Nonnull;

public class QuestionnaireEventPublisher {
    private final EventPublisher applicationEventPublisher;

    public void opened(@Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireOpenedEvent.builder().questionnaireId(questionnaireId).build());
    }

    public void created(@Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireCreatedEvent.builder().questionnaireId(questionnaireId).build());
    }

    public void completed(@Nonnull String questionnaireId) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireCompletedEvent.builder().questionnaireId(questionnaireId).build());
    }

    public void actions(@Nonnull String questionnaireId, @Nonnull Actions actions) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireActionsEvent.builder().questionnaireId(questionnaireId).actions(actions).build());
    }

    public void clientConnected(@Nonnull String questionnaireId, InetAddress client) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireClientConnectedEvent.builder().questionnaireId(questionnaireId).client(client).build());
    }

    public void clientDisconnected(@Nonnull String questionnaireId, InetAddress client, int closeStatus) {
        this.applicationEventPublisher.publish(ImmutableQuestionnaireClientDisconnectedEvent.builder().questionnaireId(questionnaireId).client(client).closeStatus(closeStatus).build());
    }

    public QuestionnaireEventPublisher(EventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

