/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.event.QuestionnaireEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QuestionnaireEvent.QuestionnaireClientDisconnectedEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireClientDisconnectedEvent
implements QuestionnaireEvent.QuestionnaireClientDisconnectedEvent {
    private final String questionnaireId;
    private final InetAddress client;
    private final int closeStatus;

    private ImmutableQuestionnaireClientDisconnectedEvent(String questionnaireId, InetAddress client, int closeStatus) {
        this.questionnaireId = questionnaireId;
        this.client = client;
        this.closeStatus = closeStatus;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public InetAddress getClient() {
        return this.client;
    }

    @Override
    public int getCloseStatus() {
        return this.closeStatus;
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireClientDisconnectedEvent(newValue, this.client, this.closeStatus);
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withClient(InetAddress value) {
        if (this.client == value) {
            return this;
        }
        InetAddress newValue = Objects.requireNonNull(value, "client");
        return new ImmutableQuestionnaireClientDisconnectedEvent(this.questionnaireId, newValue, this.closeStatus);
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withCloseStatus(int value) {
        if (this.closeStatus == value) {
            return this;
        }
        return new ImmutableQuestionnaireClientDisconnectedEvent(this.questionnaireId, this.client, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireClientDisconnectedEvent && this.equalTo((ImmutableQuestionnaireClientDisconnectedEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireClientDisconnectedEvent another) {
        return this.questionnaireId.equals(another.questionnaireId) && this.client.equals(another.client) && this.closeStatus == another.closeStatus;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.closeStatus;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QuestionnaireClientDisconnectedEvent").omitNullValues().add("questionnaireId", (Object)this.questionnaireId).add("client", (Object)this.client).add("closeStatus", this.closeStatus).toString();
    }

    public static ImmutableQuestionnaireClientDisconnectedEvent copyOf(QuestionnaireEvent.QuestionnaireClientDisconnectedEvent instance) {
        if (instance instanceof ImmutableQuestionnaireClientDisconnectedEvent) {
            return (ImmutableQuestionnaireClientDisconnectedEvent)instance;
        }
        return ImmutableQuestionnaireClientDisconnectedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireEvent.QuestionnaireClientDisconnectedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private static final long INIT_BIT_CLOSE_STATUS = 4L;
        private long initBits = 7L;
        @Nullable
        private String questionnaireId;
        @Nullable
        private InetAddress client;
        private int closeStatus;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent.QuestionnaireClientDisconnectedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof QuestionnaireEvent.QuestionnaireClientDisconnectedEvent) {
                instance = (QuestionnaireEvent.QuestionnaireClientDisconnectedEvent)object;
                this.client(instance.getClient());
                this.closeStatus(instance.getCloseStatus());
            }
        }

        @CanIgnoreReturnValue
        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(InetAddress client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closeStatus(int closeStatus) {
            this.closeStatus = closeStatus;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableQuestionnaireClientDisconnectedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireClientDisconnectedEvent(this.questionnaireId, this.client, this.closeStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("closeStatus");
            }
            return "Cannot build QuestionnaireClientDisconnectedEvent, some of required attributes are not set " + attributes;
        }
    }
}

