/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.event.QuestionnaireEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QuestionnaireEvent.QuestionnaireClientConnectedEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireClientConnectedEvent
implements QuestionnaireEvent.QuestionnaireClientConnectedEvent {
    private final String questionnaireId;
    private final InetAddress client;

    private ImmutableQuestionnaireClientConnectedEvent(String questionnaireId, InetAddress client) {
        this.questionnaireId = questionnaireId;
        this.client = client;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public InetAddress getClient() {
        return this.client;
    }

    public final ImmutableQuestionnaireClientConnectedEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireClientConnectedEvent(newValue, this.client);
    }

    public final ImmutableQuestionnaireClientConnectedEvent withClient(InetAddress value) {
        if (this.client == value) {
            return this;
        }
        InetAddress newValue = Objects.requireNonNull(value, "client");
        return new ImmutableQuestionnaireClientConnectedEvent(this.questionnaireId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireClientConnectedEvent && this.equalTo((ImmutableQuestionnaireClientConnectedEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireClientConnectedEvent another) {
        return this.questionnaireId.equals(another.questionnaireId) && this.client.equals(another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QuestionnaireClientConnectedEvent").omitNullValues().add("questionnaireId", (Object)this.questionnaireId).add("client", (Object)this.client).toString();
    }

    public static ImmutableQuestionnaireClientConnectedEvent copyOf(QuestionnaireEvent.QuestionnaireClientConnectedEvent instance) {
        if (instance instanceof ImmutableQuestionnaireClientConnectedEvent) {
            return (ImmutableQuestionnaireClientConnectedEvent)instance;
        }
        return ImmutableQuestionnaireClientConnectedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireEvent.QuestionnaireClientConnectedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private long initBits = 3L;
        @Nullable
        private String questionnaireId;
        @Nullable
        private InetAddress client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent.QuestionnaireClientConnectedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof QuestionnaireEvent.QuestionnaireClientConnectedEvent) {
                instance = (QuestionnaireEvent.QuestionnaireClientConnectedEvent)object;
                this.client(instance.getClient());
            }
        }

        @CanIgnoreReturnValue
        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(InetAddress client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQuestionnaireClientConnectedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireClientConnectedEvent(this.questionnaireId, this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build QuestionnaireClientConnectedEvent, some of required attributes are not set " + attributes;
        }
    }
}

