/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.proto.Actions;
import io.dialob.client.spi.event.QuestionnaireEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QuestionnaireEvent.QuestionnaireActionsEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireActionsEvent
implements QuestionnaireEvent.QuestionnaireActionsEvent {
    private final String questionnaireId;
    private final Actions actions;

    private ImmutableQuestionnaireActionsEvent(String questionnaireId, Actions actions) {
        this.questionnaireId = questionnaireId;
        this.actions = actions;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public Actions getActions() {
        return this.actions;
    }

    public final ImmutableQuestionnaireActionsEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireActionsEvent(newValue, this.actions);
    }

    public final ImmutableQuestionnaireActionsEvent withActions(Actions value) {
        if (this.actions == value) {
            return this;
        }
        Actions newValue = Objects.requireNonNull(value, "actions");
        return new ImmutableQuestionnaireActionsEvent(this.questionnaireId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireActionsEvent && this.equalTo((ImmutableQuestionnaireActionsEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireActionsEvent another) {
        return this.questionnaireId.equals(another.questionnaireId) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QuestionnaireActionsEvent").omitNullValues().add("questionnaireId", (Object)this.questionnaireId).add("actions", (Object)this.actions).toString();
    }

    public static ImmutableQuestionnaireActionsEvent copyOf(QuestionnaireEvent.QuestionnaireActionsEvent instance) {
        if (instance instanceof ImmutableQuestionnaireActionsEvent) {
            return (ImmutableQuestionnaireActionsEvent)instance;
        }
        return ImmutableQuestionnaireActionsEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireEvent.QuestionnaireActionsEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 1L;
        private static final long INIT_BIT_ACTIONS = 2L;
        private long initBits = 3L;
        @Nullable
        private String questionnaireId;
        @Nullable
        private Actions actions;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QuestionnaireEvent.QuestionnaireActionsEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof QuestionnaireEvent.QuestionnaireActionsEvent) {
                instance = (QuestionnaireEvent.QuestionnaireActionsEvent)object;
                this.actions(instance.getActions());
            }
        }

        @CanIgnoreReturnValue
        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Actions actions) {
            this.actions = Objects.requireNonNull(actions, "actions");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQuestionnaireActionsEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireActionsEvent(this.questionnaireId, this.actions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("actions");
            }
            return "Cannot build QuestionnaireActionsEvent, some of required attributes are not set " + attributes;
        }
    }
}

