/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.event.DistributedEvent;
import io.dialob.client.spi.event.EventPublisher;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DistributedEvent.FormTaggedEvent", generator="Immutables")
@Immutable
public final class ImmutableFormTaggedEvent
implements DistributedEvent.FormTaggedEvent {
    private final String formId;
    private final String source;
    private final String formName;
    private final String tagName;
    @Nullable
    private final String refName;

    private ImmutableFormTaggedEvent(String formId, String source, String formName, String tagName, @Nullable String refName) {
        this.formId = formId;
        this.source = source;
        this.formName = formName;
        this.tagName = tagName;
        this.refName = refName;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    @Override
    @JsonProperty(value="tagName")
    public String getTagName() {
        return this.tagName;
    }

    @Override
    @JsonProperty(value="refName")
    @Nullable
    public String getRefName() {
        return this.refName;
    }

    public final ImmutableFormTaggedEvent withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(newValue, this.source, this.formName, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.formId, newValue, this.formName, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withFormName(String value) {
        String newValue = Objects.requireNonNull(value, "formName");
        if (this.formName.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.formId, this.source, newValue, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withTagName(String value) {
        String newValue = Objects.requireNonNull(value, "tagName");
        if (this.tagName.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.formId, this.source, this.formName, newValue, this.refName);
    }

    public final ImmutableFormTaggedEvent withRefName(@Nullable String value) {
        if (Objects.equals(this.refName, value)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.formId, this.source, this.formName, this.tagName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormTaggedEvent && this.equalTo((ImmutableFormTaggedEvent)another);
    }

    private boolean equalTo(ImmutableFormTaggedEvent another) {
        return this.formId.equals(another.formId) && this.source.equals(another.source) && this.formName.equals(another.formName) && this.tagName.equals(another.tagName) && Objects.equals(this.refName, another.refName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.formName.hashCode();
        h += (h << 5) + this.tagName.hashCode();
        h += (h << 5) + Objects.hashCode(this.refName);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormTaggedEvent").omitNullValues().add("formId", (Object)this.formId).add("source", (Object)this.source).add("formName", (Object)this.formName).add("tagName", (Object)this.tagName).add("refName", (Object)this.refName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormTaggedEvent fromJson(Json json) {
        Builder builder = ImmutableFormTaggedEvent.builder();
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        if (json.formName != null) {
            builder.formName(json.formName);
        }
        if (json.tagName != null) {
            builder.tagName(json.tagName);
        }
        if (json.refName != null) {
            builder.refName(json.refName);
        }
        return builder.build();
    }

    public static ImmutableFormTaggedEvent copyOf(DistributedEvent.FormTaggedEvent instance) {
        if (instance instanceof ImmutableFormTaggedEvent) {
            return (ImmutableFormTaggedEvent)instance;
        }
        return ImmutableFormTaggedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DistributedEvent.FormTaggedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FORM_ID = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private static final long INIT_BIT_FORM_NAME = 4L;
        private static final long INIT_BIT_TAG_NAME = 8L;
        private long initBits = 15L;
        @Nullable
        private String formId;
        @Nullable
        private String source;
        @Nullable
        private String formName;
        @Nullable
        private String tagName;
        @Nullable
        private String refName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent.FormTaggedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent.FormEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EventPublisher.Event instance;
            if (object instanceof DistributedEvent) {
                instance = (DistributedEvent)object;
                this.source(instance.getSource());
            }
            if (object instanceof DistributedEvent.FormTaggedEvent) {
                instance = (DistributedEvent.FormTaggedEvent)object;
                this.tagName(instance.getTagName());
                String refNameValue = instance.getRefName();
                if (refNameValue != null) {
                    this.refName(refNameValue);
                }
                this.formName(instance.getFormName());
            }
            if (object instanceof DistributedEvent.FormEvent) {
                instance = (DistributedEvent.FormEvent)object;
                this.formId(instance.getFormId());
            }
        }

        @JsonProperty(value="formId")
        @CanIgnoreReturnValue
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="source")
        @CanIgnoreReturnValue
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="formName")
        @CanIgnoreReturnValue
        public final Builder formName(String formName) {
            this.formName = Objects.requireNonNull(formName, "formName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="tagName")
        @CanIgnoreReturnValue
        public final Builder tagName(String tagName) {
            this.tagName = Objects.requireNonNull(tagName, "tagName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="refName")
        @CanIgnoreReturnValue
        public final Builder refName(@Nullable String refName) {
            this.refName = refName;
            return this;
        }

        public ImmutableFormTaggedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormTaggedEvent(this.formId, this.source, this.formName, this.tagName, this.refName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("formName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("tagName");
            }
            return "Cannot build FormTaggedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DistributedEvent.FormTaggedEvent", generator="Immutables")
    static final class Json
    implements DistributedEvent.FormTaggedEvent {
        @Nullable
        String formId;
        @Nullable
        String source;
        @Nullable
        String formName;
        @Nullable
        String tagName;
        @Nullable
        String refName;

        Json() {
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="source")
        public void setSource(String source) {
            this.source = source;
        }

        @JsonProperty(value="formName")
        public void setFormName(String formName) {
            this.formName = formName;
        }

        @JsonProperty(value="tagName")
        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        @JsonProperty(value="refName")
        public void setRefName(@Nullable String refName) {
            this.refName = refName;
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTagName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefName() {
            throw new UnsupportedOperationException();
        }
    }
}

