/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.spi.event.DistributedEvent;
import io.dialob.client.spi.event.EventPublisher;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DistributedEvent.FormDeletedEvent", generator="Immutables")
@Immutable
public final class ImmutableFormDeletedEvent
implements DistributedEvent.FormDeletedEvent {
    private final String formId;
    private final String source;

    private ImmutableFormDeletedEvent(String formId, String source) {
        this.formId = formId;
        this.source = source;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    public final ImmutableFormDeletedEvent withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormDeletedEvent(newValue, this.source);
    }

    public final ImmutableFormDeletedEvent withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFormDeletedEvent(this.formId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormDeletedEvent && this.equalTo((ImmutableFormDeletedEvent)another);
    }

    private boolean equalTo(ImmutableFormDeletedEvent another) {
        return this.formId.equals(another.formId) && this.source.equals(another.source);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.source.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormDeletedEvent").omitNullValues().add("formId", (Object)this.formId).add("source", (Object)this.source).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormDeletedEvent fromJson(Json json) {
        Builder builder = ImmutableFormDeletedEvent.builder();
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        return builder.build();
    }

    public static ImmutableFormDeletedEvent copyOf(DistributedEvent.FormDeletedEvent instance) {
        if (instance instanceof ImmutableFormDeletedEvent) {
            return (ImmutableFormDeletedEvent)instance;
        }
        return ImmutableFormDeletedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DistributedEvent.FormDeletedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FORM_ID = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private long initBits = 3L;
        @Nullable
        private String formId;
        @Nullable
        private String source;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent.FormEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedEvent.FormDeletedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EventPublisher.Event instance;
            if (object instanceof DistributedEvent) {
                instance = (DistributedEvent)object;
                this.source(instance.getSource());
            }
            if (object instanceof DistributedEvent.FormEvent) {
                instance = (DistributedEvent.FormEvent)object;
                this.formId(instance.getFormId());
            }
        }

        @JsonProperty(value="formId")
        @CanIgnoreReturnValue
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="source")
        @CanIgnoreReturnValue
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFormDeletedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormDeletedEvent(this.formId, this.source);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build FormDeletedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DistributedEvent.FormDeletedEvent", generator="Immutables")
    static final class Json
    implements DistributedEvent.FormDeletedEvent {
        @Nullable
        String formId;
        @Nullable
        String source;

        Json() {
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="source")
        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }
    }
}

